package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询组件监控指标 */
public class Rds2MetricsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2MetricsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/teledb-dcp/v2/openapi/monitor/metrics",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public MetricsResponse send(Credential credential, MetricsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.prodEngineName != null) {
            ctReq.addParam("prodEngineName", request.prodEngineName);
            request.prodEngineName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(MetricsResponse.class);
    }

    public static class MetricsRequest {
        /** 组件类型 */
        @JsonProperty("prodEngineName")
        private String prodEngineName;

        public String getProdEngineName() {
            return this.prodEngineName;
        }

        public void setProdEngineName(String prodEngineName) {
            this.prodEngineName = prodEngineName;
        }
    }

    public static class MetricsResponse {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private MetricsReturnObjResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public MetricsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(MetricsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class MetricsReturnObjResponse {
        /** 指标详情数据 */
        @JsonProperty("data")
        private List<MetricsReturnObjDataResponse> data;

        public List<MetricsReturnObjDataResponse> getData() {
            return this.data;
        }

        public void setData(List<MetricsReturnObjDataResponse> data) {
            this.data = data;
        }
    }

    public static class MetricsReturnObjDataResponse {
        /** 指标 */
        @JsonProperty("metricsType")
        private String metricsType;

        /** 指标名 */
        @JsonProperty("name")
        private String name;

        /** 单位 */
        @JsonProperty("unit")
        private String unit;

        public String getMetricsType() {
            return this.metricsType;
        }

        public void setMetricsType(String metricsType) {
            this.metricsType = metricsType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }
    }
}
