package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 根据用户账户查询企业项目列表 */
public class Rds2ListV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2ListV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/teledb-dcp/v2/openapi/dcp-order-info/project/list",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListV2Response send(Credential credential, ListV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.prodEngineName != null) {
            ctReq.addParam("prodEngineName", request.prodEngineName);
            request.prodEngineName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListV2Response.class);
    }

    public static class ListV2Request {
        /** 产品名称：Mysql，如传" "空格等为查询全部 */
        @JsonProperty("prodEngineName")
        private String prodEngineName;

        public String getProdEngineName() {
            return this.prodEngineName;
        }

        public void setProdEngineName(String prodEngineName) {
            this.prodEngineName = prodEngineName;
        }
    }

    public static class ListV2Response {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码 。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DataResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DataResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DataResponse returnObj) {
            this.returnObj = returnObj;
        }
    }
    @Data
    public static class DataResponse {
        /**
         * 状态码
         */
        @JsonProperty("data")
        private List<ListV2ReturnObjResponse> data;


    }
    public static class ListV2ReturnObjResponse {
        /** 企业项目id */
        @JsonProperty("projectSetId")
        private String projectSetId;

        /** 企业项目名称 */
        @JsonProperty("projectSetName")
        private String projectSetName;

        /** 创建时间 */
        @JsonProperty("createTime")
        private String createTime;

        public String getProjectSetId() {
            return this.projectSetId;
        }

        public void setProjectSetId(String projectSetId) {
            this.projectSetId = projectSetId;
        }

        public String getProjectSetName() {
            return this.projectSetName;
        }

        public void setProjectSetName(String projectSetName) {
            this.projectSetName = projectSetName;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }
    }
}
