package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询实例监控数据，目前仅支持查询近30天的监控数据 */
public class Rds2InstMetricDataApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2InstMetricDataApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/teledb-dcp/v2/openapi/monitor/instMetricData",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public InstMetricDataResponse send(Credential credential, InstMetricDataRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.prodEngineName != null) {
            ctReq.addParam("prodEngineName", request.prodEngineName);
            request.prodEngineName = null;
        }
        if (request.instId != null) {
            ctReq.addParam("instId", request.instId);
            request.instId = null;
        }
        if (request.metricsType != null) {
            ctReq.addParam("metricsType", request.metricsType);
            request.metricsType = null;
        }
        if (request.period != null) {
            ctReq.addParam("period", String.valueOf(request.period));
            request.period = null;
        }
        if (request.startTime != null) {
            ctReq.addParam("startTime", String.valueOf(request.startTime));
            request.startTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", String.valueOf(request.endTime));
            request.endTime = null;
        }
        if (request.aggFunc != null) {
            ctReq.addParam("aggFunc", request.aggFunc);
            request.aggFunc = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(InstMetricDataResponse.class);
    }

    public static class InstMetricDataRequest {
        /**
         * 实例类型<br>
         * 目前仅支持Mysql, PostgreSQL
         */
        @JsonProperty("prodEngineName")
        private String prodEngineName;

        /** 实例Id */
        @JsonProperty("instId")
        private String instId;

        /** 指标 */
        @JsonProperty("metricsType")
        private String metricsType;

        /** 周期,取值为: 15, 60, 900, 3600 */
        @JsonProperty("period")
        private Integer period;

        /** 开始时间戳，精确到秒 */
        @JsonProperty("startTime")
        private Long startTime;

        /**
         * 结束时间戳，精确到秒<br>
         * 1. period取值为15时，startTime和endTime质检相差不能超过3小时<br>
         * 2. period取值为60时，startTime和endTime之间相差不能超过1天<br>
         * 3. period取值为900时，startTime和endTime之间相差不能超过15天<br>
         * 4. period取值为3600时，startTime和endTime之间相差不能超过30天
         */
        @JsonProperty("endTime")
        private Long endTime;

        /**
         * 聚合函数<br>
         * 取值为:<br>
         * 1. avg: 表示按照period指定的周期计算平均值 <br>
         * 2. max: 表示按照period指定的周期计算最大值 <br>
         * 3. min: 表示按照period指定的周期计算最小值
         */
        @JsonProperty("aggFunc")
        private String aggFunc;

        public String getProdEngineName() {
            return this.prodEngineName;
        }

        public void setProdEngineName(String prodEnginName) {
            this.prodEngineName = prodEnginName;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getMetricsType() {
            return this.metricsType;
        }

        public void setMetricsType(String metricsType) {
            this.metricsType = metricsType;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public String getAggFunc() {
            return this.aggFunc;
        }

        public void setAggFunc(String aggFunc) {
            this.aggFunc = aggFunc;
        }
    }

    public static class InstMetricDataResponse {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private InstMetricDataReturnObjResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public InstMetricDataReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(InstMetricDataReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class InstMetricDataReturnObjResponse {
        /** 指标详情数据 */
        @JsonProperty("data")
        private List<InstMetricDataReturnObjDataResponse> data;

        public List<InstMetricDataReturnObjDataResponse> getData() {
            return this.data;
        }

        public void setData(List<InstMetricDataReturnObjDataResponse> data) {
            this.data = data;
        }
    }

    public static class InstMetricDataReturnObjDataResponse {
        /** 指标名 */
        @JsonProperty("metricsType")
        private String metricsType;

        /** 标签 */
        @JsonProperty("label")
        private InstMetricDataReturnObjDataLabelResponse label;

        /** 监控数据 */
        @JsonProperty("dataPoints")
        private List<InstMetricDataReturnObjDataDataPointsResponse> dataPoints;

        public String getMetricsType() {
            return this.metricsType;
        }

        public void setMetricsType(String metricsType) {
            this.metricsType = metricsType;
        }

        public InstMetricDataReturnObjDataLabelResponse getLabel() {
            return this.label;
        }

        public void setLabel(InstMetricDataReturnObjDataLabelResponse label) {
            this.label = label;
        }

        public List<InstMetricDataReturnObjDataDataPointsResponse> getDataPoints() {
            return this.dataPoints;
        }

        public void setDataPoints(List<InstMetricDataReturnObjDataDataPointsResponse> dataPoints) {
            this.dataPoints = dataPoints;
        }
    }

    public static class InstMetricDataReturnObjDataLabelResponse {
        /** 实例id */
        @JsonProperty("outProdInstId")
        private String outProdInstId;

        /** 机器ip */
        @JsonProperty("vpcIp")
        private String vpcIp;

        /** 资源池id */
        @JsonProperty("regionId")
        private String regionId;

        /** 设备名,例如硬盘设备名 */
        @JsonProperty("device")
        private String device;

        /** 设备名,例如硬盘设备名 */
        @JsonProperty("state")
        private String state;

        /** 设备名,例如硬盘设备名 */
        @JsonProperty("type")
        private String type;

        public String getOutProdInstId() {
            return this.outProdInstId;
        }

        public void setOutProdInstId(String outProdInstId) {
            this.outProdInstId = outProdInstId;
        }

        public String getVpcIp() {
            return this.vpcIp;
        }

        public void setVpcIp(String vpcIp) {
            this.vpcIp = vpcIp;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getDevice() {
            return this.device;
        }

        public void setDevice(String device) {
            this.device = device;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class InstMetricDataReturnObjDataDataPointsResponse {
        /** 平均值，当aggFun为avg时，返回此字段 */
        @JsonProperty("avg")
        private String avg;

        /** 最大值，当aggFun为max时，返回此字段 */
        @JsonProperty("max")
        private String max;

        /** 最小值，当aggFun为min时，返回此字段 */
        @JsonProperty("min")
        private String min;

        /** 时间戳 */
        @JsonProperty("timestamp")
        private Long timestamp;

        public String getAvg() {
            return this.avg;
        }

        public void setAvg(String avg) {
            this.avg = avg;
        }

        public String getMax() {
            return this.max;
        }

        public void setMax(String max) {
            this.max = max;
        }

        public String getMin() {
            return this.min;
        }

        public void setMin(String min) {
            this.min = min;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }
    }
}
