package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询云数据库实例价格，提供OpenApi能力 */
public class Rds2InquiryForRenewOrderApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2InquiryForRenewOrderApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/teledb-acceptor/v1/openapi/accept-order-info/inquiryForRenewOrder",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public InquiryForRenewOrderResponse send(
            Credential credential, InquiryForRenewOrderRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addParam("instId", request.instId);
            request.instId = null;
        }
        if (request.month != null) {
            ctReq.addParam("month", String.valueOf(request.month));
            request.month = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(InquiryForRenewOrderResponse.class);
    }

    public static class InquiryForRenewOrderRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 数据库实例ID */
        @JsonProperty("instId")
        private String instId;

        /** 月份，取值范围[1,36] */
        @JsonProperty("month")
        private Integer month;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public Integer getMonth() {
            return this.month;
        }

        public void setMonth(Integer month) {
            this.month = month;
        }
    }

    public static class InquiryForRenewOrderResponse {
        /** 返回码，取值范围：0 成功 */
        @JsonProperty("code")
        private String code;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("data")
        private InquiryForRenewOrderDataResponse data;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public InquiryForRenewOrderDataResponse getData() {
            return this.data;
        }

        public void setData(InquiryForRenewOrderDataResponse data) {
            this.data = data;
        }
    }

    public static class InquiryForRenewOrderDataResponse {
        /** 是否成功 */
        @JsonProperty("isSucceed")
        private Boolean isSucceed;

        /** 价格 */
        @JsonProperty("finalPrice")
        private Double finalPrice;

        /** 打折价格 */
        @JsonProperty("discountPrice")
        private Double discountPrice;

        /** 状态码 */
        @JsonProperty("verifyStatusCode")
        private Integer verifyStatusCode;

        /** 总价 */
        @JsonProperty("totalPrice")
        private Double totalPrice;

        /** 子单价格 */
        @JsonProperty("subOrderPrices")
        private List<InquiryForRenewOrderDataSubOrderPricesResponse> subOrderPrices;

        public Boolean getIsSucceed() {
            return this.isSucceed;
        }

        public void setIsSucceed(Boolean isSucceed) {
            this.isSucceed = isSucceed;
        }

        public Double getFinalPrice() {
            return this.finalPrice;
        }

        public void setFinalPrice(Double finalPrice) {
            this.finalPrice = finalPrice;
        }

        public Double getDiscountPrice() {
            return this.discountPrice;
        }

        public void setDiscountPrice(Double discountPrice) {
            this.discountPrice = discountPrice;
        }

        public Integer getVerifyStatusCode() {
            return this.verifyStatusCode;
        }

        public void setVerifyStatusCode(Integer verifyStatusCode) {
            this.verifyStatusCode = verifyStatusCode;
        }

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }

        public List<InquiryForRenewOrderDataSubOrderPricesResponse> getSubOrderPrices() {
            return this.subOrderPrices;
        }

        public void setSubOrderPrices(
                List<InquiryForRenewOrderDataSubOrderPricesResponse> subOrderPrices) {
            this.subOrderPrices = subOrderPrices;
        }
    }

    public static class InquiryForRenewOrderDataSubOrderPricesResponse {
        /** 价格 */
        @JsonProperty("finalPrice")
        private Double finalPrice;

        /** 服务标签 */
        @JsonProperty("serviceTag")
        private String serviceTag;

        /** 总价 */
        @JsonProperty("totalPrice")
        private Double totalPrice;

        /**
         * 订购周期类型，0-小时，1-天，2-星期，3-月，4-季，5-年，6-两年，7-三年，8-四年，9-五年，10-六年，11-七年，12-八年，13-九年，14-十年，101-按量，200-按次
         */
        @JsonProperty("cycleType")
        private Integer cycleType;

        /** 子单价格 */
        @JsonProperty("orderItemPrices")
        private List<InquiryForRenewOrderDataSubOrderPricesOrderItemPricesResponse> orderItemPrices;

        public Double getFinalPrice() {
            return this.finalPrice;
        }

        public void setFinalPrice(Double finalPrice) {
            this.finalPrice = finalPrice;
        }

        public String getServiceTag() {
            return this.serviceTag;
        }

        public void setServiceTag(String serviceTag) {
            this.serviceTag = serviceTag;
        }

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }

        public Integer getCycleType() {
            return this.cycleType;
        }

        public void setCycleType(Integer cycleType) {
            this.cycleType = cycleType;
        }

        public List<InquiryForRenewOrderDataSubOrderPricesOrderItemPricesResponse>
                getOrderItemPrices() {
            return this.orderItemPrices;
        }

        public void setOrderItemPrices(
                List<InquiryForRenewOrderDataSubOrderPricesOrderItemPricesResponse>
                        orderItemPrices) {
            this.orderItemPrices = orderItemPrices;
        }
    }

    public static class InquiryForRenewOrderDataSubOrderPricesOrderItemPricesResponse {
        /** 价格 */
        @JsonProperty("finalPrice")
        private Double finalPrice;

        /** ID值 */
        @JsonProperty("itemId")
        private String itemId;

        /** 总价 */
        @JsonProperty("totalPrice")
        private Double totalPrice;

        /** 资源类型 */
        @JsonProperty("resourceType")
        private String resourceType;

        public Double getFinalPrice() {
            return this.finalPrice;
        }

        public void setFinalPrice(Double finalPrice) {
            this.finalPrice = finalPrice;
        }

        public String getItemId() {
            return this.itemId;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }
    }
}
