package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 获取公钥 */
public class Rds2GetPublicKeyApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetPublicKeyApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/teledb-acceptor/v2/openapi/accept-order-info/getPublicKey",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetPublicKeyResponse send(Credential credential, GetPublicKeyRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetPublicKeyResponse.class);
    }

    public static class GetPublicKeyRequest {}

    public static class GetPublicKeyResponse {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DataResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DataResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DataResponse returnObj) {
            this.returnObj = returnObj;
        }
    }
    public static class DataResponse {
        /**
         * 状态码
         */
        @JsonProperty("data")
        private String data;

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
 /*   public static class GetPublicKeyReturnObjResponse {
        *//** 公钥字符串 *//*
        @JsonProperty("String")
        private String string;

        public String getString() {
            return this.string;
        }

        public void setString(String string) {
            this.string = string;
        }
    }*/
}
