package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 用户查询实例状态 */
public class Rds2GetInstStateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetInstStateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/teledb-acceptor/v2/openapi/accept-order-info/getInstState",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetInstStateResponse send(Credential credential, GetInstStateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addParam("instId", request.instId);
            request.instId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetInstStateResponse.class);
    }

    public static class GetInstStateRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id */
        @JsonProperty("instId")
        private String instId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }
    }

    public static class GetInstStateResponse {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetInstStateReturnObjResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetInstStateReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetInstStateReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetInstStateReturnObjResponse {
        /** 实例状态，0-施工中 1-施工失败 2-运行中 3-已暂停 4-扩容中 5-已注销   */
        @JsonProperty("data")
        private Integer data;

        public Integer getData() {
            return this.data;
        }

        public void setData(Integer data) {
            this.data = data;
        }
    }
}
