package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询已下单购买的自研数据库实例，提供OpenApi能力 */
public class Rds2GetInstIdByOrderIdApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetInstIdByOrderIdApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/teledb-acceptor/v2/openapi/accept-order-info/getInstIdByOrderId",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetInstIdByOrderIdResponse send(Credential credential, GetInstIdByOrderIdRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.newOrderId != null) {
            ctReq.addParam("newOrderId", request.newOrderId);
            request.newOrderId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetInstIdByOrderIdResponse.class);
    }

    public static class GetInstIdByOrderIdRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 工单id */
        @JsonProperty("newOrderId")
        private String newOrderId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getNewOrderId() {
            return this.newOrderId;
        }

        public void setNewOrderId(String newOrderId) {
            this.newOrderId = newOrderId;
        }
    }

    public static class GetInstIdByOrderIdResponse {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetInstIdByOrderIdReturnObjResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetInstIdByOrderIdReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetInstIdByOrderIdReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetInstIdByOrderIdReturnObjResponse {
        /** 实例集合 */
        @JsonProperty("data")
        private List<String> data;

        public List<String> getData() {
            return this.data;
        }

        public void setData(List<String> data) {
            this.data = data;
        }
    }
}
