package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 用户查询弹性ip列表 */
public class Rds2EipsV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2EipsV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/teledb-dcp/v2/openapi/dcp-order-info/eips",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public EipsV2Response send(Credential credential, EipsV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addParam("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.instId != null) {
            ctReq.addParam("instId", request.instId);
            request.instId = null;
        }
        if (request.eipId != null) {
            ctReq.addParam("eipId", request.eipId);
            request.eipId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(EipsV2Response.class);
    }

    public static class EipsV2Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 资源池id */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例id */
        @JsonProperty("instId")
        private String instId;

        /** 弹性ip唯一标识 */
        @JsonProperty("eipId")
        private String eipId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getEipId() {
            return this.eipId;
        }

        public void setEipId(String eipId) {
            this.eipId = eipId;
        }
    }

    public static class EipsV2Response {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DataResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DataResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DataResponse returnObj) {
            this.returnObj = returnObj;
        }
    }
    @Data
    public static class DataResponse {
        /**
         * 状态码
         */
        @JsonProperty("data")
        private List<EipsV2ReturnObjResponse> data;


    }
    public static class EipsV2ReturnObjResponse {
        /** 弹性ip唯一标识 */
        @JsonProperty("eipId")
        private String eipId;

        /** 弹性IP */
        @JsonProperty("eip")
        private String eip;

        /** 0-未绑定，1-已绑定 */
        @JsonProperty("bindStatus")
        private String bindStatus;

        /**
         * 状态标识：ACTIVE=已使用，DOWN=未使用，ERROR=中间状态-异常，UPDATING=中间状态-更新中，BANDING_OR_UNBANGDING=中间状态-绑定或解绑中，DELETING=中间状态-删除中，DELETED=中间状态-已删除
         */
        @JsonProperty("status")
        private String status;

        /** 加入的共享带宽，单位M */
        @JsonProperty("bandWidth")
        private String bandWidth;

        public String getEipId() {
            return this.eipId;
        }

        public void setEipId(String eipId) {
            this.eipId = eipId;
        }

        public String getEip() {
            return this.eip;
        }

        public void setEip(String eip) {
            this.eip = eip;
        }

        public String getBindStatus() {
            return this.bindStatus;
        }

        public void setBindStatus(String bindStatus) {
            this.bindStatus = bindStatus;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getBandWidth() {
            return this.bandWidth;
        }

        public void setBandWidth(String bandWidth) {
            this.bandWidth = bandWidth;
        }
    }
}
