package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 给实例绑定弹性ip,方便使用 */
public class Rds2BindV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2BindV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/teledb-dcp/v2/openapi/dcp-order-info/eips/bind",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public BindV2Response send(Credential credential, BindV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BindV2Response.class);
    }

    public static class BindV2Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 弹性id */
        @JsonProperty("eipId")
        private String eipId;

        /** 弹性ip */
        @JsonProperty("eip")
        private String eip;

        /** 实例id */
        @JsonProperty("instId")
        private String instId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getEipId() {
            return this.eipId;
        }

        public void setEipId(String eipId) {
            this.eipId = eipId;
        }

        public String getEip() {
            return this.eip;
        }

        public void setEip(String eip) {
            this.eip = eip;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }
    }

    public static class BindV2Response {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}
