package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 开通自研数据库实例时，需要选择开通Region支持的可用区，该接口提供Region支持的可用区列表查询OpenApi能力 */
public class Rds2AvailabilityZoneV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2AvailabilityZoneV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/teledb-acceptor/v2/openapi/accept-order-info/availabilityZone",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public AvailabilityZoneV2Response send(Credential credential, AvailabilityZoneV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addParam("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(AvailabilityZoneV2Response.class);
    }

    public static class AvailabilityZoneV2Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 区域id */
        @JsonProperty("regionId")
        private String regionId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class AvailabilityZoneV2Response {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DataResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DataResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DataResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class DataResponse {
        /**
         * 状态码
         */
        @JsonProperty("data")
        private List<AvailabilityZoneV2ReturnObjResponse> data;

        public List<AvailabilityZoneV2ReturnObjResponse> getData() {
            return this.data;
        }

        public void setData(List<AvailabilityZoneV2ReturnObjResponse> data) {
            this.data = data;
        }


    }
    public static class AvailabilityZoneV2ReturnObjResponse {
        /** 资源池可用区Id */
        @JsonProperty("availabilityZoneId")
        private String availabilityZoneId;

        /** 资源池可用区名称 */
        @JsonProperty("availabilityZoneName")
        private String availabilityZoneName;

        /** 主机名称 */
        @JsonProperty("displayName")
        private String displayName;

        public String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public String getAvailabilityZoneName() {
            return this.availabilityZoneName;
        }

        public void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }
}
