package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 开通购买自研云数据库实例，提供OpenApi能力 */
public class Rds2AcceptV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2AcceptV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/teledb-acceptor/v2/openapi/accept-order-info/accept",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public AcceptV2Response send(Credential credential, AcceptV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(AcceptV2Response.class);
    }

    public static class AcceptV2Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 计费模式： 1是包周期，2是按需 */
        @JsonProperty("billMode")
        private String billMode;

        /** 资源池Id */
        @JsonProperty("regionId")
        private String regionId;

        /** 版本（参考查询规格列表接口） */
        @JsonProperty("prodVersion")
        private String prodVersion;

        /** 产品名称规格名称 */
        @JsonProperty("prodSpecName")
        private String prodSpecName;

        /** 实例id,需要创建只读实例， */
        @JsonProperty("instId")
        private String instId;

        /** 可用区名称 */
        @JsonProperty("availabilityZone")
        private List<String> availabilityZone;

        /** 虚拟私有云Id */
        @JsonProperty("vpcId")
        private String vpcId;

        /**
         * 主机类型 host type: 通用性:(S6
         * S7,S8),计算增强型:(C6,C7,C8),内存优化型:(M6,M7,M8),海光通用型:HS1,海光-计算增强型:HC1,海光-内存优化型:HM1,鲲鹏-通用型:KS1,鲲鹏-计算增强型:KC1,鲲鹏-内存优化型:KM1
         */
        @JsonProperty("hostType")
        private String hostType;

        /** 子网Id */
        @JsonProperty("subnetId")
        private String subnetId;

        /** 安全组 */
        @JsonProperty("securityGroupId")
        private String securityGroupId;

        /** 集群名称(若开通只读实例，默认在主实例名称后面加"-read") */
        @JsonProperty("name")
        private String name;

        /** 管理员密码（RSA公钥加密） */
        @JsonProperty("password")
        private String password;

        /** 购买时长：单位月（范围：1-36） */
        @JsonProperty("period")
        private Integer period;

        /** 购买数量(范围:1-50) */
        @JsonProperty("count")
        private Integer count;

        /** 自动续订状态 （0-不自动续订,1-自动续订） */
        @JsonProperty("autoRenewStatus")
        private Integer autoRenewStatus;

        /** 产品id */
        @JsonProperty("prodId")
        private Integer prodId;

        /** 该产品下面的单节点规格 */
        @JsonProperty("prodPerformanceSpeces")
        private List<String> prodPerformanceSpeces;

        /** mysql节点 */
        @JsonProperty("mysqlNodeInfoList")
        private List<AcceptV2MysqlNodeInfoListRequest> mysqlNodeInfoList;

        /** vpc的主网段扩展网段 */
        @JsonProperty("vpcCIDR")
        private String vpcCIDR;

        /** ipv4信息 */
        @JsonProperty("secondaryCIDRs")
        private List<String> secondaryCIDRs;

        /** 默认不传是云硬盘，传os 对应对象存储 */
        @JsonProperty("backupStorageType")
        private String backupStorageType;

        /** 时区 */
        @JsonProperty("timeZone")
        private String timeZone;

        /** cpu类型：10是鲲鹏，20是海光，30是intel */
        @JsonProperty("cpuType")
        private Integer cpuType;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getBillMode() {
            return this.billMode;
        }

        public void setBillMode(String billMode) {
            this.billMode = billMode;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdVersion() {
            return this.prodVersion;
        }

        public void setProdVersion(String prodVersion) {
            this.prodVersion = prodVersion;
        }

        public String getProdSpecName() {
            return this.prodSpecName;
        }

        public void setProdSpecName(String prodSpecName) {
            this.prodSpecName = prodSpecName;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public List<String> getAvailabilityZone() {
            return this.availabilityZone;
        }

        public void setAvailabilityZone(List<String> availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public String getHostType() {
            return this.hostType;
        }

        public void setHostType(String hostType) {
            this.hostType = hostType;
        }

        public String getSubnetId() {
            return this.subnetId;
        }

        public void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getAutoRenewStatus() {
            return this.autoRenewStatus;
        }

        public void setAutoRenewStatus(Integer autoRenewStatus) {
            this.autoRenewStatus = autoRenewStatus;
        }

        public Integer getProdId() {
            return this.prodId;
        }

        public void setProdId(Integer prodId) {
            this.prodId = prodId;
        }

        public List<String> getProdPerformanceSpeces() {
            return this.prodPerformanceSpeces;
        }

        public void setProdPerformanceSpeces(List<String> prodPerformanceSpeces) {
            this.prodPerformanceSpeces = prodPerformanceSpeces;
        }

        public List<AcceptV2MysqlNodeInfoListRequest> getMysqlNodeInfoList() {
            return this.mysqlNodeInfoList;
        }

        public void setMysqlNodeInfoList(List<AcceptV2MysqlNodeInfoListRequest> mysqlNodeInfoList) {
            this.mysqlNodeInfoList = mysqlNodeInfoList;
        }

        public String getVpcCIDR() {
            return this.vpcCIDR;
        }

        public void setVpcCIDR(String vpcCIDR) {
            this.vpcCIDR = vpcCIDR;
        }

        public List<String> getSecondaryCIDRs() {
            return this.secondaryCIDRs;
        }

        public void setSecondaryCIDRs(List<String> secondaryCIDRs) {
            this.secondaryCIDRs = secondaryCIDRs;
        }

        public String getBackupStorageType() {
            return this.backupStorageType;
        }

        public void setBackupStorageType(String backupStorageType) {
            this.backupStorageType = backupStorageType;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public Integer getCpuType() {
            return this.cpuType;
        }

        public void setCpuType(Integer cpuType) {
            this.cpuType = cpuType;
        }
    }

    public static class AcceptV2MysqlNodeInfoListRequest {
        /** master:实例规格(单机，一主一备，一主两备), readNode: 高级设置: 只读实例 */
        @JsonProperty("nodeType")
        private String nodeType;

        /** 实例规格（默认：通用型=1） */
        @JsonProperty("instSpec")
        private String instSpec;

        /** 存储类型: SSD=超高IO、SATA=普通IO、SAS=高IO、SSD-genric=通用型SSD、FAST-SSD=极速型SSD */
        @JsonProperty("storageType")
        private String storageType;

        /** 存储空间(单位:G，范围100,32768) */
        @JsonProperty("storageSpace")
        private Integer storageSpace;

        /** 规格(例: 4C8G) */
        @JsonProperty("prodPerformanceSpec")
        private String prodPerformanceSpec;

        /** 磁盘（默认为1） */
        @JsonProperty("disks")
        private Integer disks;

        /** 可用区信息 */
        @JsonProperty("availabilityZoneInfo")
        private List<AcceptV2MysqlNodeInfoListAvailabilityZoneInfoRequest> availabilityZoneInfo;

        public String getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public String getInstSpec() {
            return this.instSpec;
        }

        public void setInstSpec(String instSpec) {
            this.instSpec = instSpec;
        }

        public String getStorageType() {
            return this.storageType;
        }

        public void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public Integer getStorageSpace() {
            return this.storageSpace;
        }

        public void setStorageSpace(Integer storageSpace) {
            this.storageSpace = storageSpace;
        }

        public String getProdPerformanceSpec() {
            return this.prodPerformanceSpec;
        }

        public void setProdPerformanceSpec(String prodPerformanceSpec) {
            this.prodPerformanceSpec = prodPerformanceSpec;
        }

        public Integer getDisks() {
            return this.disks;
        }

        public void setDisks(Integer disks) {
            this.disks = disks;
        }

        public List<AcceptV2MysqlNodeInfoListAvailabilityZoneInfoRequest>
                getAvailabilityZoneInfo() {
            return this.availabilityZoneInfo;
        }

        public void setAvailabilityZoneInfo(
                List<AcceptV2MysqlNodeInfoListAvailabilityZoneInfoRequest> availabilityZoneInfo) {
            this.availabilityZoneInfo = availabilityZoneInfo;
        }
    }

    public static class AcceptV2MysqlNodeInfoListAvailabilityZoneInfoRequest {
        /** 资源池可用区名称 */
        @JsonProperty("availabilityZoneName")
        private String availabilityZoneName;

        /** 资源池可用区总数 */
        @JsonProperty("availabilityZoneCount")
        private Integer availabilityZoneCount;

        /** 表示分布AZ的节点类型，master/slave/readNode */
        @JsonProperty("nodeType")
        private String nodeType;

        public String getAvailabilityZoneName() {
            return this.availabilityZoneName;
        }

        public void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        public Integer getAvailabilityZoneCount() {
            return this.availabilityZoneCount;
        }

        public void setAvailabilityZoneCount(Integer availabilityZoneCount) {
            this.availabilityZoneCount = availabilityZoneCount;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }
    }

    public static class AcceptV2Response {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private AcceptV2ReturnObjResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public AcceptV2ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(AcceptV2ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }
    @Data
    public static class DataResponse {
        /**
         * 状态码
         */
        @JsonProperty("data")
        private AcceptV2ReturnObjResponse data;


    }
    public static class AcceptV2ReturnObjResponse {
        /** 订单id */
        @JsonProperty("newOrderId")
        private String newOrderId;

        public String getNewOrderId() {
            return this.newOrderId;
        }

        public void setNewOrderId(String newOrderId) {
            this.newOrderId = newOrderId;
        }
    }
}
