package cn.ctyun.apis.backup.v2;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 修改备份设置 */
public class Rds2UpdateBackupConfigApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2UpdateBackupConfigApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v2/open-api/backupConfig/update",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateBackupConfigResponse send(Credential credential, UpdateBackupConfigRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateBackupConfigResponse.class);
    }

    public static class UpdateBackupConfigRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 保留天数; 单位: 秒，最小为一天，即86400 */
        @JsonProperty("expiredTime")
        private String expiredTime;

        /** 高频备份 开启 关闭 */
        @JsonProperty("frequencyBackup")
        private Boolean frequencyBackup;

        /** 高频备份频率 单位: 秒，最小为1小时，即3600 */
        @JsonProperty("frequencyBackupUnittime")
        private Integer frequencyBackupUnittime;

        /** 允许最早开始备份时间 默认：00:00:00 */
        @JsonProperty("allowEarliestTime")
        private String allowEarliestTime;

        /** 开通的实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 全备触发星期，单个元素取值范围为1~7，1代表周天，2代表周一以此类推 */
        @JsonProperty("triggerDaysOfWeek")
        private List<Integer> triggerDaysOfWeek;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getExpiredTime() {
            return this.expiredTime;
        }

        public void setExpiredTime(String expiredTime) {
            this.expiredTime = expiredTime;
        }

        public Boolean getFrequencyBackup() {
            return this.frequencyBackup;
        }

        public void setFrequencyBackup(Boolean frequencyBackup) {
            this.frequencyBackup = frequencyBackup;
        }

        public Integer getFrequencyBackupUnittime() {
            return this.frequencyBackupUnittime;
        }

        public void setFrequencyBackupUnittime(Integer frequencyBackupUnittime) {
            this.frequencyBackupUnittime = frequencyBackupUnittime;
        }

        public String getAllowEarliestTime() {
            return this.allowEarliestTime;
        }

        public void setAllowEarliestTime(String allowEarliestTime) {
            this.allowEarliestTime = allowEarliestTime;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public List<Integer> getTriggerDaysOfWeek() {
            return this.triggerDaysOfWeek;
        }

        public void setTriggerDaysOfWeek(List<Integer> triggerDaysOfWeek) {
            this.triggerDaysOfWeek = triggerDaysOfWeek;
        }
    }

    public static class UpdateBackupConfigResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private UpdateBackupConfigReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpdateBackupConfigReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateBackupConfigReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class UpdateBackupConfigReturnObjResponse {}
}
