package cn.ctyun.apis.backup.v2;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取合并备份binlog任务列表 */
public class Rds2MergeBinlogTaskListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2MergeBinlogTaskListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/backup-binlog/tasks-list",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public MergeBinlogTaskListResponse send(
            Credential credential, MergeBinlogTaskListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.startTime != null) {
            ctReq.addParam("startTime", request.startTime);
            request.startTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        if (request.taskStatus != null) {
            ctReq.addParam("taskStatus", String.valueOf(request.taskStatus));
            request.taskStatus = null;
        }
        if (request.taskId != null) {
            ctReq.addParam("taskId", request.taskId);
            request.taskId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(MergeBinlogTaskListResponse.class);
    }

    public static class MergeBinlogTaskListRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 当前页 默认1 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 页大小 默认10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 开始时间 */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间 */
        @JsonProperty("endTime")
        private String endTime;

        /** 任务状态 0:初始化中 1:合并中,2:完成,3：失败,4:已取消 */
        @JsonProperty("taskStatus")
        private Integer taskStatus;

        /** 任务ID */
        @JsonProperty("taskId")
        private String taskId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public Integer getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(Integer taskStatus) {
            this.taskStatus = taskStatus;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }

    public static class MergeBinlogTaskListResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private MergeBinlogTaskListReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public MergeBinlogTaskListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(MergeBinlogTaskListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class MergeBinlogTaskListReturnObjResponse {
        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 结果集(每页显示的数据） */
        @JsonProperty("list")
        private List<MergeBinlogTaskListReturnObjListResponse> list;

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<MergeBinlogTaskListReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<MergeBinlogTaskListReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class MergeBinlogTaskListReturnObjListResponse {
        /** 任务ID */
        @JsonProperty("taskID")
        private String taskID;

        /** 任务状态 */
        @JsonProperty("taskStatus")
        private Integer taskStatus;

        /** 合并binlog开始时间 */
        @JsonProperty("taskStartTime")
        private String taskStartTime;

        /** 合并binlog结束时间 */
        @JsonProperty("taskEndTime")
        private String taskEndTime;

        /** 任务结果 */
        @JsonProperty("mergedResult")
        private List<MergeBinlogTaskListReturnObjListMergedResultResponse> mergedResult;

        public String getTaskID() {
            return this.taskID;
        }

        public void setTaskID(String taskID) {
            this.taskID = taskID;
        }

        public Integer getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(Integer taskStatus) {
            this.taskStatus = taskStatus;
        }

        public String getTaskStartTime() {
            return this.taskStartTime;
        }

        public void setTaskStartTime(String taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        public String getTaskEndTime() {
            return this.taskEndTime;
        }

        public void setTaskEndTime(String taskEndTime) {
            this.taskEndTime = taskEndTime;
        }

        public List<MergeBinlogTaskListReturnObjListMergedResultResponse> getMergedResult() {
            return this.mergedResult;
        }

        public void setMergedResult(
                List<MergeBinlogTaskListReturnObjListMergedResultResponse> mergedResult) {
            this.mergedResult = mergedResult;
        }
    }

    public static class MergeBinlogTaskListReturnObjListMergedResultResponse {
        /** 文件字节数 */
        @JsonProperty("fileSize")
        private Long fileSize;

        /** 是否为合并的binlog 0:否 1:是 */
        @JsonProperty("isMerged")
        private Integer isMerged;

        /** binlog开始时间 */
        @JsonProperty("endTs")
        private String endTs;

        /** binlog结束时间 */
        @JsonProperty("startTs")
        private String startTs;

        /** 格式化后的文件大小 */
        @JsonProperty("formatedSize")
        private String formatedSize;

        /** binlog文件名 */
        @JsonProperty("name")
        private String name;

        public Long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        public Integer getIsMerged() {
            return this.isMerged;
        }

        public void setIsMerged(Integer isMerged) {
            this.isMerged = isMerged;
        }

        public String getEndTs() {
            return this.endTs;
        }

        public void setEndTs(String endTs) {
            this.endTs = endTs;
        }

        public String getStartTs() {
            return this.startTs;
        }

        public void setStartTs(String startTs) {
            this.startTs = startTs;
        }

        public String getFormatedSize() {
            return this.formatedSize;
        }

        public void setFormatedSize(String formatedSize) {
            this.formatedSize = formatedSize;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}
