package cn.ctyun.apis.backup.v2;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 调用接口获取对象存储下载链接 */
public class Rds2GetZosObjDownloadLinkApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetZosObjDownloadLinkApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v2/open-api/backup/getZosObjDownloadLink",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetZosObjDownloadLinkResponse send(
            Credential credential, GetZosObjDownloadLinkRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.bkId != null) {
            ctReq.addParam("bkId", String.valueOf(request.bkId));
            request.bkId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetZosObjDownloadLinkResponse.class);
    }

    public static class GetZosObjDownloadLinkRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 备份记录id，与查询备份列表里backupRecordId一致 */
        @JsonProperty("bkId")
        private Integer bkId;

        /** 主机实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getBkId() {
            return this.bkId;
        }

        public void setBkId(Integer bkId) {
            this.bkId = bkId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class GetZosObjDownloadLinkResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private GetZosObjDownloadLinkReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetZosObjDownloadLinkReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetZosObjDownloadLinkReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetZosObjDownloadLinkReturnObjResponse {
        /** 链接地址 */
        @JsonProperty("downloadObjLink")
        private String downloadObjLink;

        public String getDownloadObjLink() {
            return this.downloadObjLink;
        }

        public void setDownloadObjLink(String downloadObjLink) {
            this.downloadObjLink = downloadObjLink;
        }
    }
}
