package cn.ctyun.apis.backup.v2;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 获取可恢复时间范围 */
public class Rds2GetRecoverableTimeRangeApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetRecoverableTimeRangeApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v2/open-api/recovery/recoveryable-time-range",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetRecoverableTimeRangeResponse send(
            Credential credential, GetRecoverableTimeRangeRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetRecoverableTimeRangeResponse.class);
    }

    public static class GetRecoverableTimeRangeRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 外部实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class GetRecoverableTimeRangeResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回内容 */
        @JsonProperty("returnObj")
        private GetRecoverableTimeRangeReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetRecoverableTimeRangeReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetRecoverableTimeRangeReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetRecoverableTimeRangeReturnObjResponse {
        /** 可恢复开始、结束时间戳数组 */
        @JsonProperty("data")
        private List<GetRecoverableTimeRangeReturnObjDataResponse> data;

        public List<GetRecoverableTimeRangeReturnObjDataResponse> getData() {
            return this.data;
        }

        public void setData(List<GetRecoverableTimeRangeReturnObjDataResponse> data) {
            this.data = data;
        }
    }

    public static class GetRecoverableTimeRangeReturnObjDataResponse {
        /** 开始的时间戳，格式为yyyy-MM-dd HH:mm:ss */
        @JsonProperty("startTimestamp")
        private String startTimestamp;

        /** 结束的时间戳，格式为yyyy-MM-dd HH:mm:ss */
        @JsonProperty("endTimestamp")
        private String endTimestamp;

        public String getStartTimestamp() {
            return this.startTimestamp;
        }

        public void setStartTimestamp(String startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        public String getEndTimestamp() {
            return this.endTimestamp;
        }

        public void setEndTimestamp(String endTimestamp) {
            this.endTimestamp = endTimestamp;
        }
    }
}
