package cn.ctyun.apis.backup.v2;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询所选地域当前可以进行跨地域备份的目的地域 */
public class Rds2GetCrossRegionApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetCrossRegionApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v2/open-api/backup/get-cross-region",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetCrossRegionResponse send(Credential credential, GetCrossRegionRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetCrossRegionResponse.class);
    }

    public static class GetCrossRegionRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetCrossRegionResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetCrossRegionReturnObjResponse returnObj;

        /** 结果信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public GetCrossRegionReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetCrossRegionReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetCrossRegionReturnObjResponse {
        /** 返回对象 */
        @JsonProperty("data")
        private List<GetCrossRegionReturnObjDataResponse> data;

        public List<GetCrossRegionReturnObjDataResponse> getData() {
            return this.data;
        }

        public void setData(List<GetCrossRegionReturnObjDataResponse> data) {
            this.data = data;
        }
    }

    public static class GetCrossRegionReturnObjDataResponse {
        /** 跨区域对象存储的区域Id */
        @JsonProperty("regionId")
        private String regionId;

        /** 跨区域区域名字 */
        @JsonProperty("regionCnName")
        private String regionCnName;

        /** 跨区域对象存储的服务的Id */
        @JsonProperty("s3ServiceId")
        private String s3ServiceId;

        /** 是否是当前资源池 */
        @JsonProperty("currentRegion")
        private Boolean currentRegion;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getRegionCnName() {
            return this.regionCnName;
        }

        public void setRegionCnName(String regionCnName) {
            this.regionCnName = regionCnName;
        }

        public String getS3ServiceId() {
            return this.s3ServiceId;
        }

        public void setS3ServiceId(String s3ServiceId) {
            this.s3ServiceId = s3ServiceId;
        }

        public Boolean getCurrentRegion() {
            return this.currentRegion;
        }

        public void setCurrentRegion(Boolean currentRegion) {
            this.currentRegion = currentRegion;
        }
    }
}