package cn.ctyun.apis.backup.v2;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询RDS实例跨地域备份设置 */
public class Rds2GetCrossConfigApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetCrossConfigApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v2/open-api/backupConfig/get-cross-config",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetCrossConfigResponse send(Credential credential, GetCrossConfigRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetCrossConfigResponse.class);
    }

    public static class GetCrossConfigRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 主机实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class GetCrossConfigResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetCrossConfigReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetCrossConfigReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetCrossConfigReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetCrossConfigReturnObjResponse {
        /** 返回数据 */
        @JsonProperty("data")
        private List<GetCrossConfigReturnObjDataResponse> data;

        public List<GetCrossConfigReturnObjDataResponse> getData() {
            return this.data;
        }

        public void setData(List<GetCrossConfigReturnObjDataResponse> data) {
            this.data = data;
        }
    }

    public static class GetCrossConfigReturnObjDataResponse {
        /** 跨域备份配置id */
        @JsonProperty("id")
        private Integer id;

        /** 实例id */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** 用户id */
        @JsonProperty("userId")
        private Long userId;

        /** 跨域恢复源资源池名称 */
        @JsonProperty("srcRegionName")
        private String srcRegionName;

        /** 跨域恢复目标资源池名称 */
        @JsonProperty("dstRegionName")
        private String dstRegionName;

        /** 跨域恢复源资源池id */
        @JsonProperty("srcRegionId")
        private String srcRegionId;

        /** 跨域恢复目标资源池id */
        @JsonProperty("dstRegionId")
        private String dstRegionId;

        /** 跨域备份额外配置 */
        @JsonProperty("config")
        private String config;

        /** 跨域备份规则id */
        @JsonProperty("fuId")
        private String fuId;

        /** 跨域备份开启时间 */
        @JsonProperty("createTime")
        private String createTime;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Long getUserId() {
            return this.userId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public String getSrcRegionName() {
            return this.srcRegionName;
        }

        public void setSrcRegionName(String srcRegionName) {
            this.srcRegionName = srcRegionName;
        }

        public String getDstRegionName() {
            return this.dstRegionName;
        }

        public void setDstRegionName(String dstRegionName) {
            this.dstRegionName = dstRegionName;
        }

        public String getSrcRegionId() {
            return this.srcRegionId;
        }

        public void setSrcRegionId(String srcRegionId) {
            this.srcRegionId = srcRegionId;
        }

        public String getDstRegionId() {
            return this.dstRegionId;
        }

        public void setDstRegionId(String dstRegionId) {
            this.dstRegionId = dstRegionId;
        }

        public String getConfig() {
            return this.config;
        }

        public void setConfig(String config) {
            this.config = config;
        }

        public String getFuId() {
            return this.fuId;
        }

        public void setFuId(String fuId) {
            this.fuId = fuId;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }
    }
}