package cn.ctyun.apis.backup.v2;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询实例跨地域数据备份文件列表 */
public class Rds2GetCrossBakListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetCrossBakListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v2/open-api/backup/cross-bak-list",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetCrossBakListResponse send(Credential credential, GetCrossBakListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.prodInstName != null) {
            ctReq.addParam("prodInstName", request.prodInstName);
            request.prodInstName = null;
        }
        if (request.backupName != null) {
            ctReq.addParam("backupName", request.backupName);
            request.backupName = null;
        }
        if (request.blockId != null) {
            ctReq.addParam("blockId", String.valueOf(request.blockId));
            request.blockId = null;
        }
        if (request.brTaskType != null) {
            ctReq.addParam("brTaskType", request.brTaskType);
            request.brTaskType = null;
        }
        if (request.startTime != null) {
            ctReq.addParam("startTime", request.startTime);
            request.startTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.taskStatus != null) {
            ctReq.addParam("taskStatus", String.valueOf(request.taskStatus));
            request.taskStatus = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetCrossBakListResponse.class);
    }

    public static class GetCrossBakListRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 外部实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 实例名 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 备份名 */
        @JsonProperty("backupName")
        private String backupName;

        /** 备份周期id */
        @JsonProperty("blockId")
        private Long blockId;

        /** full-全量备份，incr-增量备份，table-库表备份 */
        @JsonProperty("brTaskType")
        private String brTaskType;

        /** 开始时间，"yyyy-MM-dd HH:mm:ss"格式。startTime参数与endTime同时输入时生效，二者仅输入其一将不会按照时间进行筛选 */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间，"yyyy-MM-dd HH:mm:ss"格式。startTime参数与endTime同时输入时生效，二者仅输入其一将不会按照时间进行筛选 */
        @JsonProperty("endTime")
        private String endTime;

        /** 当前页，最小为1，默认为1 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 分页大小,最小为10，最大为100，默认为10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 备份结果 1-成功； -1-失败； 0备份中；100-待提交；101-已提交；102-已取消 备份终止；103-跳过；104-待重试 */
        @JsonProperty("taskStatus")
        private Integer taskStatus;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public String getBackupName() {
            return this.backupName;
        }

        public void setBackupName(String backupName) {
            this.backupName = backupName;
        }

        public Long getBlockId() {
            return this.blockId;
        }

        public void setBlockId(Long blockId) {
            this.blockId = blockId;
        }

        public String getBrTaskType() {
            return this.brTaskType;
        }

        public void setBrTaskType(String brTaskType) {
            this.brTaskType = brTaskType;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(Integer taskStatus) {
            this.taskStatus = taskStatus;
        }
    }

    public static class GetCrossBakListResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetCrossBakListReturnObjResponse returnObj;

        /** 结果信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public GetCrossBakListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetCrossBakListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetCrossBakListReturnObjResponse {
        /** 最后一页 */
        @JsonProperty("navigateLastPage")
        private Integer navigateLastPage;

        /** 所有导航页号 */
        @JsonProperty("navigatepageNums")
        private List<Integer> navigatepageNums;

        /** 当前页面第一个元素在数据库中的行号 */
        @JsonProperty("startRow")
        private Integer startRow;

        /** 是否有下一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 下一页 */
        @JsonProperty("nextPage")
        private Integer nextPage;

        /** 当前页面最后一个元素在数据库中的行号 */
        @JsonProperty("endRow")
        private Integer endRow;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 结果集(每页显示的数据) */
        @JsonProperty("list")
        private List<GetCrossBakListReturnObjListResponse> list;

        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 导航页码数 */
        @JsonProperty("navigatePages")
        private Integer navigatePages;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 第一页 */
        @JsonProperty("navigateFirstPage")
        private Integer navigateFirstPage;

        /** 当前页的数量 */
        @JsonProperty("size")
        private Integer size;

        /** 是否为第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 是否为最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        public Integer getNavigateLastPage() {
            return this.navigateLastPage;
        }

        public void setNavigateLastPage(Integer navigateLastPage) {
            this.navigateLastPage = navigateLastPage;
        }

        public List<Integer> getNavigatepageNums() {
            return this.navigatepageNums;
        }

        public void setNavigatepageNums(List<Integer> navigatepageNums) {
            this.navigatepageNums = navigatepageNums;
        }

        public Integer getStartRow() {
            return this.startRow;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Integer getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(Integer nextPage) {
            this.nextPage = nextPage;
        }

        public Integer getEndRow() {
            return this.endRow;
        }

        public void setEndRow(Integer endRow) {
            this.endRow = endRow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public List<GetCrossBakListReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<GetCrossBakListReturnObjListResponse> list) {
            this.list = list;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getNavigatePages() {
            return this.navigatePages;
        }

        public void setNavigatePages(Integer navigatePages) {
            this.navigatePages = navigatePages;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getNavigateFirstPage() {
            return this.navigateFirstPage;
        }

        public void setNavigateFirstPage(Integer navigateFirstPage) {
            this.navigateFirstPage = navigateFirstPage;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Boolean getIsFirstPage() {
            return this.isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }
    }

    public static class GetCrossBakListReturnObjListResponse {
        /** 块id */
        @JsonProperty("blockId")
        private Long blockId;

        /** 外部实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** rds数据库实例名称 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 备份记录集合 */
        @JsonProperty("records")
        private List<GetCrossBakListReturnObjListRecordsResponse> records;

        /** 内部实例id */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** 目标资源池id */
        @JsonProperty("targetRegionId")
        private String targetRegionId;

        public Long getBlockId() {
            return this.blockId;
        }

        public void setBlockId(Long blockId) {
            this.blockId = blockId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public List<GetCrossBakListReturnObjListRecordsResponse> getRecords() {
            return this.records;
        }

        public void setRecords(List<GetCrossBakListReturnObjListRecordsResponse> records) {
            this.records = records;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getTargetRegionId() {
            return this.targetRegionId;
        }

        public void setTargetRegionId(String targetRegionId) {
            this.targetRegionId = targetRegionId;
        }
    }

    public static class GetCrossBakListReturnObjListRecordsResponse {
        /** 备份记录id */
        @JsonProperty("backupRecordId")
        private Long backupRecordId;

        /** 实例标识 */
        @JsonProperty("prodInstFlag")
        private String prodInstFlag;

        /** 备份描述 */
        @JsonProperty("description")
        private String description;

        /** 备份开始时间 */
        @JsonProperty("backupStartTime")
        private String backupStartTime;

        /** 外部实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 备份大小: bytes（字节） */
        @JsonProperty("backedUpDataSize")
        private Long backedUpDataSize;

        /** 备份任务id */
        @JsonProperty("backupTaskId")
        private Long backupTaskId;

        /** 备份结束时间 */
        @JsonProperty("backupEndTime")
        private String backupEndTime;

        /** 备份的实例id */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** 禁用备份 */
        @JsonProperty("disabled")
        private Boolean disabled;

        /** 备份名称 */
        @JsonProperty("backupName")
        private String backupName;

        /** 展示大小；单位自动适配 */
        @JsonProperty("backedUpDataSizeHuman")
        private String backedUpDataSizeHuman;

        /** 任务id */
        @JsonProperty("taskId")
        private String taskId;

        /** 目标资源池名称 */
        @JsonProperty("targetRegionName")
        private String targetRegionName;

        /** 目标资源池id */
        @JsonProperty("targetRegionId")
        private String targetRegionId;

        /** 实例set名称 */
        @JsonProperty("prodInstSetName")
        private String prodInstSetName;

        /** 实例名称 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 备份时间点 */
        @JsonProperty("backedUpTimestamp")
        private Long backedUpTimestamp;

        /** 额外参数 */
        @JsonProperty("extData")
        private GetCrossBakListReturnObjListRecordsExtDataResponse extData;

        public Long getBackupRecordId() {
            return this.backupRecordId;
        }

        public void setBackupRecordId(Long backupRecordId) {
            this.backupRecordId = backupRecordId;
        }

        public String getProdInstFlag() {
            return this.prodInstFlag;
        }

        public void setProdInstFlag(String prodInstFlag) {
            this.prodInstFlag = prodInstFlag;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getBackupStartTime() {
            return this.backupStartTime;
        }

        public void setBackupStartTime(String backupStartTime) {
            this.backupStartTime = backupStartTime;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Long getBackedUpDataSize() {
            return this.backedUpDataSize;
        }

        public void setBackedUpDataSize(Long backedUpDataSize) {
            this.backedUpDataSize = backedUpDataSize;
        }

        public Long getBackupTaskId() {
            return this.backupTaskId;
        }

        public void setBackupTaskId(Long backupTaskId) {
            this.backupTaskId = backupTaskId;
        }

        public String getBackupEndTime() {
            return this.backupEndTime;
        }

        public void setBackupEndTime(String backupEndTime) {
            this.backupEndTime = backupEndTime;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Boolean getDisabled() {
            return this.disabled;
        }

        public void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        public String getBackupName() {
            return this.backupName;
        }

        public void setBackupName(String backupName) {
            this.backupName = backupName;
        }

        public String getBackedUpDataSizeHuman() {
            return this.backedUpDataSizeHuman;
        }

        public void setBackedUpDataSizeHuman(String backedUpDataSizeHuman) {
            this.backedUpDataSizeHuman = backedUpDataSizeHuman;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getTargetRegionName() {
            return this.targetRegionName;
        }

        public void setTargetRegionName(String targetRegionName) {
            this.targetRegionName = targetRegionName;
        }

        public String getTargetRegionId() {
            return this.targetRegionId;
        }

        public void setTargetRegionId(String targetRegionId) {
            this.targetRegionId = targetRegionId;
        }

        public String getProdInstSetName() {
            return this.prodInstSetName;
        }

        public void setProdInstSetName(String prodInstSetName) {
            this.prodInstSetName = prodInstSetName;
        }

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public Long getBackedUpTimestamp() {
            return this.backedUpTimestamp;
        }

        public void setBackedUpTimestamp(Long backedUpTimestamp) {
            this.backedUpTimestamp = backedUpTimestamp;
        }

        public GetCrossBakListReturnObjListRecordsExtDataResponse getExtData() {
            return this.extData;
        }

        public void setExtData(GetCrossBakListReturnObjListRecordsExtDataResponse extData) {
            this.extData = extData;
        }
    }

    public static class GetCrossBakListReturnObjListRecordsExtDataResponse {}
}
