package cn.ctyun.apis.backup.v2;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用接口获取备份任务列表 */
public class Rds2GetBackupListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetBackupListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/RDS2/v2/open-api/backup/list", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetBackupListResponse send(Credential credential, GetBackupListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.prodInstName != null) {
            ctReq.addParam("prodInstName", request.prodInstName);
            request.prodInstName = null;
        }
        if (request.backupName != null) {
            ctReq.addParam("backupName", request.backupName);
            request.backupName = null;
        }
        if (request.blockId != null) {
            ctReq.addParam("blockId", String.valueOf(request.blockId));
            request.blockId = null;
        }
        if (request.startTime != null) {
            ctReq.addParam("startTime", request.startTime);
            request.startTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetBackupListResponse.class);
    }

    public static class GetBackupListRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 外部实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 实例名 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 备份名 */
        @JsonProperty("backupName")
        private String backupName;

        /** 备份周期id */
        @JsonProperty("blockId")
        private Long blockId;

        /** 开始时间 */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间 */
        @JsonProperty("endTime")
        private String endTime;

        /** 当前页 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 分页大小 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public String getBackupName() {
            return this.backupName;
        }

        public void setBackupName(String backupName) {
            this.backupName = backupName;
        }

        public Long getBlockId() {
            return this.blockId;
        }

        public void setBlockId(Long blockId) {
            this.blockId = blockId;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class GetBackupListResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private GetBackupListReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetBackupListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetBackupListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetBackupListReturnObjResponse {
        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 当前页的数量 */
        @JsonProperty("size")
        private Integer size;

        /** 当前页面第一个元素在数据库中的行号 */
        @JsonProperty("startRow")
        private Integer startRow;

        /** 当前页面最后一个元素在数据库中的行号 */
        @JsonProperty("endRow")
        private Integer endRow;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 是否为第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 是否为最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 是否有下一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 导航页码数 */
        @JsonProperty("navigatePages")
        private Integer navigatePages;

        /** 结果集(每页显示的数据) */
        @JsonProperty("list")
        private List<GetBackupListReturnObjListResponse> list;

        /** 页面上显示的最后一个页码 */
        @JsonProperty("navigateLastPage")
        private Integer navigateLastPage;

        /** 页面显示的第一个页码 */
        @JsonProperty("navigateFirstPage")
        private String navigateFirstPage;

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getStartRow() {
            return this.startRow;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public Integer getEndRow() {
            return this.endRow;
        }

        public void setEndRow(Integer endRow) {
            this.endRow = endRow;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Boolean getIsFirstPage() {
            return this.isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Integer getNavigatePages() {
            return this.navigatePages;
        }

        public void setNavigatePages(Integer navigatePages) {
            this.navigatePages = navigatePages;
        }

        public List<GetBackupListReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<GetBackupListReturnObjListResponse> list) {
            this.list = list;
        }

        public Integer getNavigateLastPage() {
            return this.navigateLastPage;
        }

        public void setNavigateLastPage(Integer navigateLastPage) {
            this.navigateLastPage = navigateLastPage;
        }

        public String getNavigateFirstPage() {
            return this.navigateFirstPage;
        }

        public void setNavigateFirstPage(String navigateFirstPage) {
            this.navigateFirstPage = navigateFirstPage;
        }
    }

    public static class GetBackupListReturnObjListResponse {
        /** 实例id */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** 外部实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 实例名称 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 格式化总大小 */
        @JsonProperty("backupSizeHuman")
        private String backupSizeHuman;

        /** 备份集总大小 */
        @JsonProperty("totalSizeHuman")
        private String totalSizeHuman;

        /** 备份周期id */
        @JsonProperty("blockId")
        private Integer blockId;

        /** 备份记录集合 */
        @JsonProperty("records")
        private List<GetBackupListReturnObjListRecordsResponse> records;

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public String getBackupSizeHuman() {
            return this.backupSizeHuman;
        }

        public void setBackupSizeHuman(String backupSizeHuman) {
            this.backupSizeHuman = backupSizeHuman;
        }

        public String getTotalSizeHuman() {
            return this.totalSizeHuman;
        }

        public void setTotalSizeHuman(String totalSizeHuman) {
            this.totalSizeHuman = totalSizeHuman;
        }

        public Integer getBlockId() {
            return this.blockId;
        }

        public void setBlockId(Integer blockId) {
            this.blockId = blockId;
        }

        public List<GetBackupListReturnObjListRecordsResponse> getRecords() {
            return this.records;
        }

        public void setRecords(List<GetBackupListReturnObjListRecordsResponse> records) {
            this.records = records;
        }
    }

    public static class GetBackupListReturnObjListRecordsResponse {
        /** 备份记录id */
        @JsonProperty("backupRecordId")
        private Long backupRecordId;

        /** 备份任务id */
        @JsonProperty("backupTaskId")
        private Long backupTaskId;

        /** 任务id */
        @JsonProperty("taskId")
        private String taskId;

        /** 备份名称 */
        @JsonProperty("backupName")
        private String backupName;

        /** 实例id */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** 外部实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 实例名称 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 备份描述 */
        @JsonProperty("description")
        private String description;

        /**
         * 存储类型；<br>
         * 对象存储： s3<br>
         * 本地存储：disk <br>
         * 跨区域备份：region_s3
         */
        @JsonProperty("storageType")
        private String storageType;

        /**
         * 操作类型 <br>
         * 自动备份: auto<br>
         * 手工备份: manual
         */
        @JsonProperty("opType")
        private String opType;

        /**
         * 备份类型，取值<br>
         * 全量备份：full,<br>
         * 增量备份：incr
         */
        @JsonProperty("taskType")
        private String taskType;

        /**
         * 等待开始：100;<br>
         * 已提交：101; <br>
         * 已取消：102; 成功: 1；<br>
         * 失败: -1; <br>
         * 备份中：其他值
         */
        @JsonProperty("taskStatus")
        private Integer taskStatus;

        /** 备份大小: bytes（字节） */
        @JsonProperty("backedUpDataSize")
        private String backedUpDataSize;

        /** 展示大小；单位自动适配 */
        @JsonProperty("backedUpDataSizeHuman")
        private String backedUpDataSizeHuman;

        /** 备份开始时间 */
        @JsonProperty("backupStartTime")
        private String backupStartTime;

        /** 备份结束时间 */
        @JsonProperty("backupEndTime")
        private String backupEndTime;

        /** 禁用备份 */
        @JsonProperty("disabled")
        private Boolean disabled;

        public Long getBackupRecordId() {
            return this.backupRecordId;
        }

        public void setBackupRecordId(Long backupRecordId) {
            this.backupRecordId = backupRecordId;
        }

        public Long getBackupTaskId() {
            return this.backupTaskId;
        }

        public void setBackupTaskId(Long backupTaskId) {
            this.backupTaskId = backupTaskId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getBackupName() {
            return this.backupName;
        }

        public void setBackupName(String backupName) {
            this.backupName = backupName;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getStorageType() {
            return this.storageType;
        }

        public void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public String getOpType() {
            return this.opType;
        }

        public void setOpType(String opType) {
            this.opType = opType;
        }

        public String getTaskType() {
            return this.taskType;
        }

        public void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public Integer getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(Integer taskStatus) {
            this.taskStatus = taskStatus;
        }

        public String getBackedUpDataSize() {
            return this.backedUpDataSize;
        }

        public void setBackedUpDataSize(String backedUpDataSize) {
            this.backedUpDataSize = backedUpDataSize;
        }

        public String getBackedUpDataSizeHuman() {
            return this.backedUpDataSizeHuman;
        }

        public void setBackedUpDataSizeHuman(String backedUpDataSizeHuman) {
            this.backedUpDataSizeHuman = backedUpDataSizeHuman;
        }

        public String getBackupStartTime() {
            return this.backupStartTime;
        }

        public void setBackupStartTime(String backupStartTime) {
            this.backupStartTime = backupStartTime;
        }

        public String getBackupEndTime() {
            return this.backupEndTime;
        }

        public void setBackupEndTime(String backupEndTime) {
            this.backupEndTime = backupEndTime;
        }

        public Boolean getDisabled() {
            return this.disabled;
        }

        public void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }
    }
}
