package cn.ctyun.apis.backup.v2;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取备份配置列表 */
public class Rds2GetBackupConfigListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetBackupConfigListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v2/open-api/backupConfig/list",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetBackupConfigListResponse send(
            Credential credential, GetBackupConfigListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetBackupConfigListResponse.class);
    }

    public static class GetBackupConfigListRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 主机实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 当前页 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 分页大小 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class GetBackupConfigListResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetBackupConfigListReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetBackupConfigListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetBackupConfigListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetBackupConfigListReturnObjResponse {
        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 当前页的数量 */
        @JsonProperty("size")
        private Integer size;

        /** 当前页面第一个元素在数据库中的行号 */
        @JsonProperty("startRow")
        private Integer startRow;

        /** 当前页面最后一个元素在数据库中的行号 */
        @JsonProperty("endRow")
        private Integer endRow;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 是否为第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 是否为最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 是否有下一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 导航页码数 */
        @JsonProperty("navigatePages")
        private Integer navigatePages;

        /** 所有导航页号 */
        @JsonProperty("navigatepageNums")
        private List<Integer> navigatepageNums;

        /** 结果集(每页显示的数据) */
        @JsonProperty("list")
        private List<GetBackupConfigListReturnObjListResponse> list;

        /** 页面上显示的最后一个页码 */
        @JsonProperty("navigateLastPage")
        private Integer navigateLastPage;

        /** 页面显示的第一个页码 */
        @JsonProperty("navigateFirstPage")
        private String navigateFirstPage;

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getStartRow() {
            return this.startRow;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public Integer getEndRow() {
            return this.endRow;
        }

        public void setEndRow(Integer endRow) {
            this.endRow = endRow;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Boolean getIsFirstPage() {
            return this.isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Integer getNavigatePages() {
            return this.navigatePages;
        }

        public void setNavigatePages(Integer navigatePages) {
            this.navigatePages = navigatePages;
        }

        public List<Integer> getNavigatepageNums() {
            return this.navigatepageNums;
        }

        public void setNavigatepageNums(List<Integer> navigatepageNums) {
            this.navigatepageNums = navigatepageNums;
        }

        public List<GetBackupConfigListReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<GetBackupConfigListReturnObjListResponse> list) {
            this.list = list;
        }

        public Integer getNavigateLastPage() {
            return this.navigateLastPage;
        }

        public void setNavigateLastPage(Integer navigateLastPage) {
            this.navigateLastPage = navigateLastPage;
        }

        public String getNavigateFirstPage() {
            return this.navigateFirstPage;
        }

        public void setNavigateFirstPage(String navigateFirstPage) {
            this.navigateFirstPage = navigateFirstPage;
        }
    }

    public static class GetBackupConfigListReturnObjListResponse {
        /** 主键ID */
        @JsonProperty("id")
        private Integer id;

        /** 实例ID */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** 首次开始备份的时间 */
        @JsonProperty("firstbackuptime")
        private String firstbackuptime;

        /** 每两次备份的时间间隔,以秒为单位 */
        @JsonProperty("backupunittime")
        private Integer backupunittime;

        /** 保留天数; 单位: 秒,默认1天 */
        @JsonProperty("expiredTime")
        private String expiredTime;

        /** 高频备份 开启 关闭 */
        @JsonProperty("frequencyBackup")
        private Boolean frequencyBackup;

        /** 高频备份频率 单位: 秒,默认1小时 */
        @JsonProperty("frequencyBackupUnittime")
        private Integer frequencyBackupUnittime;

        /** 允许最早开始备份时间 默认：00:00:00 */
        @JsonProperty("allowEarliestTime")
        private String allowEarliestTime;

        /** 当前状态: 0表示没有任何操作, 1表示当前正在备份, 2表示当前正在恢复 */
        @JsonProperty("status")
        private Integer status;

        /** 是否开启自动备份操作 */
        @JsonProperty("backupOperation")
        private Boolean backupOperation;

        /** 实例名称 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 开通的实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 工具心跳 */
        @JsonProperty("backuprecoveryHeartbeatOk")
        private Boolean backuprecoveryHeartbeatOk;

        /** 实时同步心跳 */
        @JsonProperty("syncerHeartbeatOk")
        private Boolean syncerHeartbeatOk;

        /** 使用对象存储时桶名称 */
        @JsonProperty("bucketName")
        private String bucketName;

        /** 是否开启跨域备份 */
        @JsonProperty("crossRegion")
        private Boolean crossRegion;

        /** 使用监控机时备份存储路径 */
        @JsonProperty("storePath")
        private String storePath;

        /** 备份使用资源id */
        @JsonProperty("backupInfoId")
        private Integer backupInfoId;

        /** 备份所在资源池id */
        @JsonProperty("region")
        private String region;

        /** 是否使用对象存储，0代表否，1代表是 */
        @JsonProperty("usezos")
        private Integer usezos;

        /** 跨域备份的目标资源池id */
        @JsonProperty("targetCrossRegion")
        private String targetCrossRegion;

        /** 最小可以设置的备份过期时间，单位为秒 */
        @JsonProperty("minExpiredTime")
        private Integer minExpiredTime;

        /** 最大可以设置的备份过期时间，单位为秒 */
        @JsonProperty("maxExpiredTime")
        private Integer maxExpiredTime;

        /** 备份资源名称 */
        @JsonProperty("resourceName")
        private String resourceName;

        /** 对应syncer是否开启了syncer保活 */
        @JsonProperty("configSyncerKeepAlive")
        private Boolean configSyncerKeepAlive;

        /** 全备触发星期，单个元素取值范围为1~7，1代表周天，2代表周一以此类推 */
        @JsonProperty("triggerDaysOfWeek")
        private List<Integer> triggerDaysOfWeek;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getFirstbackuptime() {
            return this.firstbackuptime;
        }

        public void setFirstbackuptime(String firstbackuptime) {
            this.firstbackuptime = firstbackuptime;
        }

        public Integer getBackupunittime() {
            return this.backupunittime;
        }

        public void setBackupunittime(Integer backupunittime) {
            this.backupunittime = backupunittime;
        }

        public String getExpiredTime() {
            return this.expiredTime;
        }

        public void setExpiredTime(String expiredTime) {
            this.expiredTime = expiredTime;
        }

        public Boolean getFrequencyBackup() {
            return this.frequencyBackup;
        }

        public void setFrequencyBackup(Boolean frequencyBackup) {
            this.frequencyBackup = frequencyBackup;
        }

        public Integer getFrequencyBackupUnittime() {
            return this.frequencyBackupUnittime;
        }

        public void setFrequencyBackupUnittime(Integer frequencyBackupUnittime) {
            this.frequencyBackupUnittime = frequencyBackupUnittime;
        }

        public String getAllowEarliestTime() {
            return this.allowEarliestTime;
        }

        public void setAllowEarliestTime(String allowEarliestTime) {
            this.allowEarliestTime = allowEarliestTime;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Boolean getBackupOperation() {
            return this.backupOperation;
        }

        public void setBackupOperation(Boolean backupOperation) {
            this.backupOperation = backupOperation;
        }

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Boolean getBackuprecoveryHeartbeatOk() {
            return this.backuprecoveryHeartbeatOk;
        }

        public void setBackuprecoveryHeartbeatOk(Boolean backuprecoveryHeartbeatOk) {
            this.backuprecoveryHeartbeatOk = backuprecoveryHeartbeatOk;
        }

        public Boolean getSyncerHeartbeatOk() {
            return this.syncerHeartbeatOk;
        }

        public void setSyncerHeartbeatOk(Boolean syncerHeartbeatOk) {
            this.syncerHeartbeatOk = syncerHeartbeatOk;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public Boolean getCrossRegion() {
            return this.crossRegion;
        }

        public void setCrossRegion(Boolean crossRegion) {
            this.crossRegion = crossRegion;
        }

        public String getStorePath() {
            return this.storePath;
        }

        public void setStorePath(String storePath) {
            this.storePath = storePath;
        }

        public Integer getBackupInfoId() {
            return this.backupInfoId;
        }

        public void setBackupInfoId(Integer backupInfoId) {
            this.backupInfoId = backupInfoId;
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public Integer getUsezos() {
            return this.usezos;
        }

        public void setUsezos(Integer usezos) {
            this.usezos = usezos;
        }

        public String getTargetCrossRegion() {
            return this.targetCrossRegion;
        }

        public void setTargetCrossRegion(String targetCrossRegion) {
            this.targetCrossRegion = targetCrossRegion;
        }

        public Integer getMinExpiredTime() {
            return this.minExpiredTime;
        }

        public void setMinExpiredTime(Integer minExpiredTime) {
            this.minExpiredTime = minExpiredTime;
        }

        public Integer getMaxExpiredTime() {
            return this.maxExpiredTime;
        }

        public void setMaxExpiredTime(Integer maxExpiredTime) {
            this.maxExpiredTime = maxExpiredTime;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public Boolean getConfigSyncerKeepAlive() {
            return this.configSyncerKeepAlive;
        }

        public void setConfigSyncerKeepAlive(Boolean configSyncerKeepAlive) {
            this.configSyncerKeepAlive = configSyncerKeepAlive;
        }

        public List<Integer> getTriggerDaysOfWeek() {
            return this.triggerDaysOfWeek;
        }

        public void setTriggerDaysOfWeek(List<Integer> triggerDaysOfWeek) {
            this.triggerDaysOfWeek = triggerDaysOfWeek;
        }
    }
}
