package cn.ctyun.apis.backup.v2;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用接口获取备份任务信息 */
public class Rds2GetBackupApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetBackupApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/RDS2/v2/open-api/backup/get", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetBackupResponse send(Credential credential, GetBackupRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.id != null) {
            ctReq.addParam("id", String.valueOf(request.id));
            request.id = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetBackupResponse.class);
    }

    public static class GetBackupRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 备份记录id，与查询备份列表里backupRecordId一致 */
        @JsonProperty("id")
        private Integer id;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }
    }

    public static class GetBackupResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private GetBackupReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetBackupReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetBackupReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetBackupReturnObjResponse {
        /** 备份记录id */
        @JsonProperty("backupRecordId")
        private Long backupRecordId;

        /** 备份任务id */
        @JsonProperty("backupTaskId")
        private Long backupTaskId;

        /** 任务id */
        @JsonProperty("taskId")
        private String taskId;

        /** 备份名称 */
        @JsonProperty("backupName")
        private String backupName;

        /** 实例id */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** 外部实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 实例名称 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 备份描述 */
        @JsonProperty("description")
        private String description;

        /**
         * 存储类型；<br>
         * 对象存储： s3<br>
         * 本地存储：disk <br>
         * 跨区域备份：region_s3
         */
        @JsonProperty("storageType")
        private String storageType;

        /**
         * 操作类型 <br>
         * 自动备份: auto<br>
         * 手工备份: manual
         */
        @JsonProperty("opType")
        private String opType;

        /**
         * 备份类型，取值<br>
         * 全量备份：full,<br>
         * 增量备份：incr
         */
        @JsonProperty("taskType")
        private String taskType;

        /**
         * 等待开始：100;<br>
         * 已提交：101; <br>
         * 已取消：102; 成功: 1；<br>
         * 失败: -1; <br>
         * 备份中：其他值
         */
        @JsonProperty("taskStatus")
        private Integer taskStatus;

        /** 备份大小: bytes（字节） */
        @JsonProperty("backedUpDataSize")
        private String backedUpDataSize;

        /** 展示大小；单位自动适配 */
        @JsonProperty("backedUpDataSizeHuman")
        private String backedUpDataSizeHuman;

        /** 备份开始时间 */
        @JsonProperty("backupStartTime")
        private String backupStartTime;

        /** 备份结束时间 */
        @JsonProperty("backupEndTime")
        private String backupEndTime;

        /** 禁用备份 */
        @JsonProperty("disabled")
        private Boolean disabled;

        public Long getBackupRecordId() {
            return this.backupRecordId;
        }

        public void setBackupRecordId(Long backupRecordId) {
            this.backupRecordId = backupRecordId;
        }

        public Long getBackupTaskId() {
            return this.backupTaskId;
        }

        public void setBackupTaskId(Long backupTaskId) {
            this.backupTaskId = backupTaskId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getBackupName() {
            return this.backupName;
        }

        public void setBackupName(String backupName) {
            this.backupName = backupName;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getStorageType() {
            return this.storageType;
        }

        public void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public String getOpType() {
            return this.opType;
        }

        public void setOpType(String opType) {
            this.opType = opType;
        }

        public String getTaskType() {
            return this.taskType;
        }

        public void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public Integer getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(Integer taskStatus) {
            this.taskStatus = taskStatus;
        }

        public String getBackedUpDataSize() {
            return this.backedUpDataSize;
        }

        public void setBackedUpDataSize(String backedUpDataSize) {
            this.backedUpDataSize = backedUpDataSize;
        }

        public String getBackedUpDataSizeHuman() {
            return this.backedUpDataSizeHuman;
        }

        public void setBackedUpDataSizeHuman(String backedUpDataSizeHuman) {
            this.backedUpDataSizeHuman = backedUpDataSizeHuman;
        }

        public String getBackupStartTime() {
            return this.backupStartTime;
        }

        public void setBackupStartTime(String backupStartTime) {
            this.backupStartTime = backupStartTime;
        }

        public String getBackupEndTime() {
            return this.backupEndTime;
        }

        public void setBackupEndTime(String backupEndTime) {
            this.backupEndTime = backupEndTime;
        }

        public Boolean getDisabled() {
            return this.disabled;
        }

        public void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }
    }
}