package cn.ctyun.apis.backup.v2;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 跨域恢复到新实例 */
public class Rds2CrossRecoveryApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2CrossRecoveryApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/order/cross-recovery",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CrossRecoveryResponse send(Credential credential, CrossRecoveryRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CrossRecoveryResponse.class);
    }

    public static class CrossRecoveryRequest {

        @JsonProperty("header-project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("header-regionId")
        private String regionId;

        /** 源实例id */
        @JsonProperty("sourceInstId")
        private String sourceInstId;

        /** 跨域恢复目标资源池ID */
        @JsonProperty("regionId")
        private String targetRegionId;

        /** 计费模式，1是包周期，2是按需 */
        @JsonProperty("billMode")
        private Byte billMode;

        /** 主机类型:“S7” or "S6" */
        @JsonProperty("hostType")
        private String hostType;

        /** mysql节点列表,此列表长度必须为1 */
        @JsonProperty("mysqlNodeInfoList")
        private List<CrossRecoveryMysqlNodeInfoListRequest> mysqlNodeInfoList;

        /** 备份id */
        @JsonProperty("backupId")
        private Long backupId;

        /** 新实例虚拟私有云id（目标资源池） */
        @JsonProperty("vpcId")
        private String vpcId;

        /** 新实例子网id（目标资源池） */
        @JsonProperty("subnetId")
        private String subnetId;

        /** 新实例安全组id（目标资源池） */
        @JsonProperty("securityGroupId")
        private String securityGroupId;

        /** 新实例名称 */
        @JsonProperty("name")
        private String name;

        /** 自动扩容参数，默认不开启自动扩容 */
        @JsonProperty("autoScaleParam")
        private CrossRecoveryAutoScaleParamRequest autoScaleParam;

        /** 新实例密码 */
        @JsonProperty("password")
        private String password;

        /** 订购时间，单位为月，默认为6 */
        @JsonProperty("period")
        private Integer period;

        /** 订购数量，默认为1 */
        @JsonProperty("count")
        private Integer count;

        /** 自动续订状态，0代表不自动续订，1代表自动续订，默认为1 */
        @JsonProperty("autoRenewStatus")
        private Integer autoRenewStatus;

        /** 实例时区,默认为“+8:00” */
        @JsonProperty("timeZone")
        private String timeZone;

        /** 企业项目id，默认为“0” */
        @JsonProperty("projectId")
        private String requestProjectId;

        public String getSourceInstId() {
            return this.sourceInstId;
        }

        public void setSourceInstId(String sourceInstId) {
            this.sourceInstId = sourceInstId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Byte getBillMode() {
            return this.billMode;
        }

        public void setBillMode(Byte billMode) {
            this.billMode = billMode;
        }

        public String getHostType() {
            return this.hostType;
        }

        public void setHostType(String hostType) {
            this.hostType = hostType;
        }

        public List<CrossRecoveryMysqlNodeInfoListRequest> getMysqlNodeInfoList() {
            return this.mysqlNodeInfoList;
        }

        public void setMysqlNodeInfoList(
                List<CrossRecoveryMysqlNodeInfoListRequest> mysqlNodeInfoList) {
            this.mysqlNodeInfoList = mysqlNodeInfoList;
        }

        public Long getBackupId() {
            return this.backupId;
        }

        public void setBackupId(Long backupId) {
            this.backupId = backupId;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public String getSubnetId() {
            return this.subnetId;
        }

        public void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public CrossRecoveryAutoScaleParamRequest getAutoScaleParam() {
            return this.autoScaleParam;
        }

        public void setAutoScaleParam(CrossRecoveryAutoScaleParamRequest autoScaleParam) {
            this.autoScaleParam = autoScaleParam;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getAutoRenewStatus() {
            return this.autoRenewStatus;
        }

        public void setAutoRenewStatus(Integer autoRenewStatus) {
            this.autoRenewStatus = autoRenewStatus;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getTargetRegionId() {
            return targetRegionId;
        }

        public void setTargetRegionId(String targetRegionId) {
            this.targetRegionId = targetRegionId;
        }

        public String getRequestProjectId() {
            return requestProjectId;
        }

        public void setRequestProjectId(String requestProjectId) {
            this.requestProjectId = requestProjectId;
        }
    }

    public static class CrossRecoveryMysqlNodeInfoListRequest {
        /** master:实例规格(单机，一主一备，一主两备) */
        @JsonProperty("nodeType")
        private String nodeType;

        /** 实例规格（默认：通用型=1） */
        @JsonProperty("instSpec")
        private String instSpec;

        /** 存储类型: SSD=超高IO、SATA=普通IO、SAS=高IO、SSD-genric=通用型SSD、FAST-SSD=极速型SSD */
        @JsonProperty("storageType")
        private String storageType;

        /** 存储空间(单位:G，范围100,32768) */
        @JsonProperty("storageSpace")
        private Integer storageSpace;

        /** 规格(例: 4C8G) */
        @JsonProperty("prodPerformanceSpec")
        private String prodPerformanceSpec;

        /** 磁盘（默认为1） */
        @JsonProperty("disks")
        private Integer disks;

        /** 可用区信息 */
        @JsonProperty("availabilityZoneInfo")
        private List<CrossRecoveryMysqlNodeInfoListAvailabilityZoneInfoRequest>
                availabilityZoneInfo;

        public String getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public String getInstSpec() {
            return this.instSpec;
        }

        public void setInstSpec(String instSpec) {
            this.instSpec = instSpec;
        }

        public String getStorageType() {
            return this.storageType;
        }

        public void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public Integer getStorageSpace() {
            return this.storageSpace;
        }

        public void setStorageSpace(Integer storageSpace) {
            this.storageSpace = storageSpace;
        }

        public String getProdPerformanceSpec() {
            return this.prodPerformanceSpec;
        }

        public void setProdPerformanceSpec(String prodPerformanceSpec) {
            this.prodPerformanceSpec = prodPerformanceSpec;
        }

        public Integer getDisks() {
            return this.disks;
        }

        public void setDisks(Integer disks) {
            this.disks = disks;
        }

        public List<CrossRecoveryMysqlNodeInfoListAvailabilityZoneInfoRequest>
                getAvailabilityZoneInfo() {
            return this.availabilityZoneInfo;
        }

        public void setAvailabilityZoneInfo(
                List<CrossRecoveryMysqlNodeInfoListAvailabilityZoneInfoRequest>
                        availabilityZoneInfo) {
            this.availabilityZoneInfo = availabilityZoneInfo;
        }
    }

    public static class CrossRecoveryAutoScaleParamRequest {
        /** 是否开启自动扩容，0 不开启， 1 开启 */
        @JsonProperty("autoScale")
        private Integer autoScale;

        /** 存储扩容上线，单位GB */
        @JsonProperty("maxScale")
        private Integer maxScale;

        /** 触发存储扩容百分比， 取值 1-100 */
        @JsonProperty("activeScaleRate")
        private Integer activeScaleRate;

        public Integer getAutoScale() {
            return this.autoScale;
        }

        public void setAutoScale(Integer autoScale) {
            this.autoScale = autoScale;
        }

        public Integer getMaxScale() {
            return this.maxScale;
        }

        public void setMaxScale(Integer maxScale) {
            this.maxScale = maxScale;
        }

        public Integer getActiveScaleRate() {
            return this.activeScaleRate;
        }

        public void setActiveScaleRate(Integer activeScaleRate) {
            this.activeScaleRate = activeScaleRate;
        }
    }

    public static class CrossRecoveryMysqlNodeInfoListAvailabilityZoneInfoRequest {
        /** 资源池可用区名称 */
        @JsonProperty("availabilityZoneName")
        private String availabilityZoneName;

        /** 资源池可用区总数 */
        @JsonProperty("availabilityZoneCount")
        private Integer availabilityZoneCount;

        /** 表示分布AZ的节点类型，取值 master/slave， 有且仅有一个master节点， 最多两个slave节点 */
        @JsonProperty("nodeType")
        private String nodeType;

        public String getAvailabilityZoneName() {
            return this.availabilityZoneName;
        }

        public void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        public Integer getAvailabilityZoneCount() {
            return this.availabilityZoneCount;
        }

        public void setAvailabilityZoneCount(Integer availabilityZoneCount) {
            this.availabilityZoneCount = availabilityZoneCount;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }
    }

    public static class CrossRecoveryResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private CrossRecoveryReturnObjResponse returnObj;

        /** 结果信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public CrossRecoveryReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CrossRecoveryReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CrossRecoveryReturnObjResponse {
        /** 返回数据 */
        @JsonProperty("data")
        private CrossRecoveryReturnObjDataResponse data;

        public CrossRecoveryReturnObjDataResponse getData() {
            return this.data;
        }

        public void setData(CrossRecoveryReturnObjDataResponse data) {
            this.data = data;
        }
    }

    public static class CrossRecoveryReturnObjDataResponse {
        /** 订单编号 */
        @JsonProperty("newOrderNo")
        private String newOrderNo;

        /** 订单是否提交 */
        @JsonProperty("submitted")
        private Boolean submitted;

        /** 订单价格，单位元 */
        @JsonProperty("totalPrice")
        private Float totalPrice;

        /** 订单id */
        @JsonProperty("newOrderId")
        private String newOrderId;

        /** 错误信息 */
        @JsonProperty("errorMessage")
        private String errorMessage;

        public String getNewOrderNo() {
            return this.newOrderNo;
        }

        public void setNewOrderNo(String newOrderNo) {
            this.newOrderNo = newOrderNo;
        }

        public Boolean getSubmitted() {
            return this.submitted;
        }

        public void setSubmitted(Boolean submitted) {
            this.submitted = submitted;
        }

        public Float getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Float totalPrice) {
            this.totalPrice = totalPrice;
        }

        public String getNewOrderId() {
            return this.newOrderId;
        }

        public void setNewOrderId(String newOrderId) {
            this.newOrderId = newOrderId;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }
}
