package cn.ctyun.apis.backup.v2;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询跨地域日志备份文件列表 */
public class Rds2CrossBinlogListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2CrossBinlogListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/binlog/cross-binlog-list",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CrossBinlogListResponse send(Credential credential, CrossBinlogListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();

        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.crossRegionId != null) {
            ctReq.addParam("crossRegionId", request.crossRegionId);
            request.crossRegionId = null;
        }
        if (request.startTime != null) {
            ctReq.addParam("startTime", request.startTime);
            request.startTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CrossBinlogListResponse.class);
    }

    public static class CrossBinlogListRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 区域ID */
        @JsonProperty("crossRegionId")
        private String crossRegionId;

        /** binlog起始时间，格式yyyy-MM-dd HH:mm:ss */
        @JsonProperty("startTime")
        private String startTime;

        /** binlog结束时间，格式yyyy-MM-dd HH:mm:ss */
        @JsonProperty("endTime")
        private String endTime;

        /** 当前页 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 页面记录数(最小为1，最大为100) */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getCrossRegionId() {
            return this.crossRegionId;
        }

        public void setCrossRegionId(String crossRegionId) {
            this.crossRegionId = crossRegionId;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getProjectId() {
            return projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class CrossBinlogListResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private CrossBinlogListReturnObjResponse returnObj;

        /** 结果信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public CrossBinlogListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CrossBinlogListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CrossBinlogListReturnObjResponse {
        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 结果集 */
        @JsonProperty("list")
        private List<CrossBinlogListReturnObjListResponse> list;

        /** 当前页码 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public List<CrossBinlogListReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<CrossBinlogListReturnObjListResponse> list) {
            this.list = list;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }
    }

    public static class CrossBinlogListReturnObjListResponse {
        /** binlog文件名称 */
        @JsonProperty("binlogName")
        private String binlogName;

        /** binlog开始时间 */
        @JsonProperty("startTime")
        private String startTime;

        /** binlog结束时间 */
        @JsonProperty("endTime")
        private String endTime;

        /** binlog文件的大小 */
        @JsonProperty("binlogSize")
        private String binlogSize;

        /** 是否是合并后的binlog， 0代表不是， 1代表是 */
        @JsonProperty("isMerged")
        private Byte isMerged;

        public String getBinlogName() {
            return this.binlogName;
        }

        public void setBinlogName(String binlogName) {
            this.binlogName = binlogName;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public String getBinlogSize() {
            return this.binlogSize;
        }

        public void setBinlogSize(String binlogSize) {
            this.binlogSize = binlogSize;
        }

        public Byte getIsMerged() {
            return this.isMerged;
        }

        public void setIsMerged(Byte isMerged) {
            this.isMerged = isMerged;
        }
    }
}
