package cn.ctyun.apis.backup.v2;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 创建恢复任务 */
public class Rds2CreateNewRecoveryJobApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2CreateNewRecoveryJobApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v2/open-api/recovery/createNewRecoveryJob",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateNewRecoveryJobResponse send(
            Credential credential, CreateNewRecoveryJobRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateNewRecoveryJobResponse.class);
    }

    public static class CreateNewRecoveryJobRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 恢复的源实例 */
        @JsonProperty("srcOuterProdInstId")
        private String srcOuterProdInstId;

        /** 恢复的目标实例 */
        @JsonProperty("dstOuterProdInstId")
        private String dstOuterProdInstId;

        /** 恢复到的时间点，格式为：yyyy-MM-dd HH:mm:ss【taskId和toTimepoint不能同时为空，优先取toTimepoint】 */
        @JsonProperty("toTimepoint")
        private String toTimepoint;

        /** 用来恢复的备份任务集【taskId和toTimepoint不能同时为空，优先取toTimepoint】 */
        @JsonProperty("taskId")
        private String taskId;

        /** 恢复的库名 */
        @JsonProperty("restoreDbName")
        private String restoreDbName;

        /** 恢复的表名 */
        @JsonProperty("restoreTables")
        private List<String> restoreTables;

        /** 新的库名 */
        @JsonProperty("newDbName")
        private String newDbName;

        /** 新的表名 */
        @JsonProperty("newTables")
        private List<String> newTables;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getSrcOuterProdInstId() {
            return this.srcOuterProdInstId;
        }

        public void setSrcOuterProdInstId(String srcOuterProdInstId) {
            this.srcOuterProdInstId = srcOuterProdInstId;
        }

        public String getDstOuterProdInstId() {
            return this.dstOuterProdInstId;
        }

        public void setDstOuterProdInstId(String dstOuterProdInstId) {
            this.dstOuterProdInstId = dstOuterProdInstId;
        }

        public String getToTimepoint() {
            return this.toTimepoint;
        }

        public void setToTimepoint(String toTimepoint) {
            this.toTimepoint = toTimepoint;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getRestoreDbName() {
            return this.restoreDbName;
        }

        public void setRestoreDbName(String restoreDbName) {
            this.restoreDbName = restoreDbName;
        }

        public List<String> getRestoreTables() {
            return this.restoreTables;
        }

        public void setRestoreTables(List<String> restoreTables) {
            this.restoreTables = restoreTables;
        }

        public String getNewDbName() {
            return this.newDbName;
        }

        public void setNewDbName(String newDbName) {
            this.newDbName = newDbName;
        }

        public List<String> getNewTables() {
            return this.newTables;
        }

        public void setNewTables(List<String> newTables) {
            this.newTables = newTables;
        }
    }

    public static class CreateNewRecoveryJobResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 任务记录主键id */
        @JsonProperty("returnObj")
        private CreateNewRecoveryJobReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CreateNewRecoveryJobReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateNewRecoveryJobReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CreateNewRecoveryJobReturnObjResponse {
        /** 恢复任务id */
        @JsonProperty("data")
        private String data;

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}
