package cn.ctyun.apis.backup.v2;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用接口终止备份中一个备份集 */
public class Rds2CancelBackupApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2CancelBackupApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v2/open-api/backup/cancel",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CancelBackupResponse send(Credential credential, CancelBackupRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.backupRecordId != null) {
            ctReq.addParam("backupRecordId", String.valueOf(request.backupRecordId));
            request.backupRecordId = null;
        }
        ctReq.writePostNoBody(template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CancelBackupResponse.class);
    }

    public static class CancelBackupRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 备份记录，与查询备份列表里backupRecordId一致 */
        @JsonProperty("backupRecordId")
        private Integer backupRecordId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getBackupRecordId() {
            return this.backupRecordId;
        }

        public void setBackupRecordId(Integer backupRecordId) {
            this.backupRecordId = backupRecordId;
        }
    }

    public static class CancelBackupResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private CancelBackupReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CancelBackupReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CancelBackupReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CancelBackupReturnObjResponse {}
}
