package cn.ctyun.apis.backup.v2;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 调用接口获取备份binlog对象存储下载链接 */
public class Rds2BinlogDownloadApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2BinlogDownloadApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/backup-binlog/download-binlog",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public BinlogDownloadResponse send(Credential credential, BinlogDownloadRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.binlogName != null) {
            ctReq.addParam("binlogName", request.binlogName);
            request.binlogName = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.isMerged != null) {
            ctReq.addParam("isMerged", String.valueOf(request.isMerged));
            request.isMerged = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BinlogDownloadResponse.class);
    }

    public static class BinlogDownloadRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 备份binlog文件名 */
        @JsonProperty("binlogName")
        private String binlogName;

        /** 主机实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 是否为合并的binlog 0:否 1:是 */
        @JsonProperty("isMerged")
        private Integer isMerged;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getBinlogName() {
            return this.binlogName;
        }

        public void setBinlogName(String binlogName) {
            this.binlogName = binlogName;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getIsMerged() {
            return this.isMerged;
        }

        public void setIsMerged(Integer isMerged) {
            this.isMerged = isMerged;
        }
    }

    public static class BinlogDownloadResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private BinlogDownloadReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public BinlogDownloadReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(BinlogDownloadReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class BinlogDownloadReturnObjResponse {
        /** 链接地址 */
        @JsonProperty("downloadLink")
        private String downloadLink;

        /** 链接创建时间 */
        @JsonProperty("createtime")
        private String createtime;

        /** 链接过期时间 */
        @JsonProperty("expiretime")
        private String expiretime;

        /** 链接是否有效 1:有效 0:失效 */
        @JsonProperty("status")
        private Integer status;

        public String getDownloadLink() {
            return this.downloadLink;
        }

        public void setDownloadLink(String downloadLink) {
            this.downloadLink = downloadLink;
        }

        public String getCreatetime() {
            return this.createtime;
        }

        public void setCreatetime(String createtime) {
            this.createtime = createtime;
        }

        public String getExpiretime() {
            return this.expiretime;
        }

        public void setExpiretime(String expiretime) {
            this.expiretime = expiretime;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }
    }
}
