package cn.ctyun.apis.backup;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 获取备份binlog列表 */
public class Rds2BackupBinlogListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2BackupBinlogListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/backup-binlog/binlogs-list",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public BackupBinlogListResponse send(Credential credential, BackupBinlogListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.isMerged != null) {
            ctReq.addParam("isMerged", String.valueOf(request.isMerged));
            request.isMerged = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.startTime != null) {
            ctReq.addParam("startTime", request.startTime);
            request.startTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BackupBinlogListResponse.class);
    }

    public static class BackupBinlogListRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 是否为合并的binlog 0:否 1:是 */
        @JsonProperty("isMerged")
        private Integer isMerged;

        /** 当前页 默认1 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 页大小 默认10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 开始时间 */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间 */
        @JsonProperty("endTime")
        private String endTime;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getIsMerged() {
            return this.isMerged;
        }

        public void setIsMerged(Integer isMerged) {
            this.isMerged = isMerged;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }
    }

    public static class BackupBinlogListResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private BackupBinlogListReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public BackupBinlogListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(BackupBinlogListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class BackupBinlogListReturnObjResponse {
        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 结果集(每页显示的数据） */
        @JsonProperty("list")
        private List<BackupBinlogListReturnObjListResponse> list;

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<BackupBinlogListReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<BackupBinlogListReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class BackupBinlogListReturnObjListResponse {
        /** binlog文件名 */
        @JsonProperty("binlogName")
        private String binlogName;

        /** binlog文件大小 */
        @JsonProperty("binlogSize")
        private String binlogSize;

        /** 是否为合并的binlog 0:否 1:是 */
        @JsonProperty("isMerged")
        private Integer isMerged;

        /** binlog开始时间 */
        @JsonProperty("startTime")
        private String startTime;

        /** binlog结束时间 */
        @JsonProperty("endTime")
        private String endTime;

        public String getBinlogName() {
            return this.binlogName;
        }

        public void setBinlogName(String binlogName) {
            this.binlogName = binlogName;
        }

        public String getBinlogSize() {
            return this.binlogSize;
        }

        public void setBinlogSize(String binlogSize) {
            this.binlogSize = binlogSize;
        }

        public Integer getIsMerged() {
            return this.isMerged;
        }

        public void setIsMerged(Integer isMerged) {
            this.isMerged = isMerged;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }
    }
}
