package cn.ctyun.apis.account;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 一个账号可授权访问一个或多个数据库的DML或DDL基础权限。 */
public class Rds2GrantOperatorPrivilegeV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GrantOperatorPrivilegeV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/account/operator-privilege-grant",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GrantOperatorPrivilegeV4Response send(
            Credential credential, GrantOperatorPrivilegeV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GrantOperatorPrivilegeV4Response.class);
    }

    public static class GrantOperatorPrivilegeV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 账户名称 */
        @JsonProperty("accountName")
        private String accountName;

        /** 用户赋权列表 */
        @JsonProperty("schemaPrivilegeVOList")
        private List<GrantOperatorPrivilegeV4SchemaPrivilegeVOListRequest> schemaPrivilegeVOList;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public List<GrantOperatorPrivilegeV4SchemaPrivilegeVOListRequest>
                getSchemaPrivilegeVOList() {
            return this.schemaPrivilegeVOList;
        }

        public void setSchemaPrivilegeVOList(
                List<GrantOperatorPrivilegeV4SchemaPrivilegeVOListRequest> schemaPrivilegeVOList) {
            this.schemaPrivilegeVOList = schemaPrivilegeVOList;
        }
    }

    public static class GrantOperatorPrivilegeV4SchemaPrivilegeVOListRequest {
        /** 赋权数据库名 */
        @JsonProperty("grantSchema")
        private String grantSchema;

        /** 是否是只读权限 */
        @JsonProperty("readOnly")
        private Boolean readOnly;

        /** True赋DML基本权限 */
        @JsonProperty("dmlPrivilege")
        private Boolean dmlPrivilege;

        /** True赋DDL基本权限 */
        @JsonProperty("ddlPrivilege")
        private Boolean ddlPrivilege;

        /** 是否是读写权限 */
        @JsonProperty("readAndWrite")
        private Boolean readAndWrite;

        public String getGrantSchema() {
            return this.grantSchema;
        }

        public void setGrantSchema(String grantSchema) {
            this.grantSchema = grantSchema;
        }

        public Boolean getReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public Boolean getDmlPrivilege() {
            return this.dmlPrivilege;
        }

        public void setDmlPrivilege(Boolean dmlPrivilege) {
            this.dmlPrivilege = dmlPrivilege;
        }

        public Boolean getDdlPrivilege() {
            return this.ddlPrivilege;
        }

        public void setDdlPrivilege(Boolean ddlPrivilege) {
            this.ddlPrivilege = ddlPrivilege;
        }

        public Boolean getReadAndWrite() {
            return this.readAndWrite;
        }

        public void setReadAndWrite(Boolean readAndWrite) {
            this.readAndWrite = readAndWrite;
        }
    }

    public static class GrantOperatorPrivilegeV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GrantOperatorPrivilegeV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GrantOperatorPrivilegeV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GrantOperatorPrivilegeV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GrantOperatorPrivilegeV4ReturnObjResponse {}
}
