package cn.ctyun.apis.account;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 根据userId和prodInstId获取实例的数据库账户信息 */
public class Rds2GetUserAccountV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetUserAccountV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/RDS2/v1/open-api/account", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetUserAccountV4Response send(Credential credential, GetUserAccountV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetUserAccountV4Response.class);
    }

    public static class GetUserAccountV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class GetUserAccountV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<GetUserAccountV4ReturnObjResponse> returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<GetUserAccountV4ReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<GetUserAccountV4ReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetUserAccountV4ReturnObjResponse {
        /** 数据库账号 */
        @JsonProperty("accountName")
        private String accountName;

        private String remark;

        /** 数据库权限列表 */
        @JsonProperty("schemaPrivilegeVOList")
        private List<GetUserAccountV4ReturnObjSchemaPrivilegeVOListResponse> schemaPrivilegeVOList;

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public List<GetUserAccountV4ReturnObjSchemaPrivilegeVOListResponse>
                getSchemaPrivilegeVOList() {
            return this.schemaPrivilegeVOList;
        }

        public void setSchemaPrivilegeVOList(
                List<GetUserAccountV4ReturnObjSchemaPrivilegeVOListResponse>
                        schemaPrivilegeVOList) {
            this.schemaPrivilegeVOList = schemaPrivilegeVOList;
        }

        public String getRemark() {
            return remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }
    }

    public static class GetUserAccountV4ReturnObjSchemaPrivilegeVOListResponse {
        /** 是否只读 */
        @JsonProperty("readOnly")
        private Boolean readOnly;

        /** DB数据库名 */
        @JsonProperty("grantSchema")
        private String grantSchema;

        private String readAndWrite;

        private String dmlPrivilege;

        private String ddlPrivilege;

        public Boolean getReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public String getGrantSchema() {
            return this.grantSchema;
        }

        public void setGrantSchema(String grantSchema) {
            this.grantSchema = grantSchema;
        }

        public String getReadAndWrite() {
            return this.readAndWrite;
        }

        public void setReadAndWrite(String readAndWrite) {
            this.readAndWrite = readAndWrite;
        }

        public String getDmlPrivilege() {
            return this.dmlPrivilege;
        }

        public void setDmlPrivilege(String dmlPrivilege) {
            this.dmlPrivilege = dmlPrivilege;
        }

        public String getDdlPrivilege() {
            return this.ddlPrivilege;
        }

        public void setDdlPrivilege(String ddlPrivilege) {
            this.ddlPrivilege = ddlPrivilege;
        }
    }
}
