package cn.ctyun.apis.account;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 调用接口查询数据库账号账户赋权详情 */
public class Rds2GetUserAccountDetailV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetUserAccountDetailV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/account/account-detail",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetUserAccountDetailV4Response send(
            Credential credential, GetUserAccountDetailV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.accountName != null) {
            ctReq.addParam("accountName", request.accountName);
            request.accountName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetUserAccountDetailV4Response.class);
    }

    public static class GetUserAccountDetailV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 数据库账户名 */
        @JsonProperty("accountName")
        private String accountName;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }
    }

    public static class GetUserAccountDetailV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<GetUserAccountDetailV4ReturnObjResponse> returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<GetUserAccountDetailV4ReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<GetUserAccountDetailV4ReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetUserAccountDetailV4ReturnObjResponse {
        /** 数据库账户名 */
        @JsonProperty("accountName")
        private String accountName;

        /** 授权数据库名 */
        @JsonProperty("grantSchema")
        private String grantSchema;

        /** 用户是否可以通过SELECT命令选择数据 */
        @JsonProperty("selectPriv")
        private String selectPriv;

        /** 用户是否可以通过INSERT命令插入数据 */
        @JsonProperty("insertPriv")
        private String insertPriv;

        /** 用户是否可以通过UPDATE命令修改现有数据 */
        @JsonProperty("updatePriv")
        private String updatePriv;

        /** 用户是否可以通过DELETE命令删除现有数据 */
        @JsonProperty("deletePriv")
        private String deletePriv;

        /** 用户是否可以创建新的数据库和表 */
        @JsonProperty("createPriv")
        private String createPriv;

        /** 用户是否可以删除现有数据库和表 */
        @JsonProperty("dropPriv")
        private String dropPriv;

        /** 用户是否可以查看视图或了解视图如何执行，此权限只在MySQL 5.0及更高版本中有意义 */
        @JsonProperty("show_viewPriv")
        private String show_viewPriv;

        /** 用户是否可以修改或删除存储函数及函数，此权限是在MySQL 5.0中引入的 */
        @JsonProperty("alterPriv")
        private String alterPriv;

        /** 用户是否可以创建和删除表索引 */
        @JsonProperty("indexPriv")
        private String indexPriv;

        /** 用户是否可以使用LOCK */
        @JsonProperty("lockTablePriv")
        private String lockTablePriv;

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public String getGrantSchema() {
            return this.grantSchema;
        }

        public void setGrantSchema(String grantSchema) {
            this.grantSchema = grantSchema;
        }

        public String getSelectPriv() {
            return this.selectPriv;
        }

        public void setSelectPriv(String selectPriv) {
            this.selectPriv = selectPriv;
        }

        public String getInsertPriv() {
            return this.insertPriv;
        }

        public void setInsertPriv(String insertPriv) {
            this.insertPriv = insertPriv;
        }

        public String getUpdatePriv() {
            return this.updatePriv;
        }

        public void setUpdatePriv(String updatePriv) {
            this.updatePriv = updatePriv;
        }

        public String getDeletePriv() {
            return this.deletePriv;
        }

        public void setDeletePriv(String deletePriv) {
            this.deletePriv = deletePriv;
        }

        public String getCreatePriv() {
            return this.createPriv;
        }

        public void setCreatePriv(String createPriv) {
            this.createPriv = createPriv;
        }

        public String getDropPriv() {
            return this.dropPriv;
        }

        public void setDropPriv(String dropPriv) {
            this.dropPriv = dropPriv;
        }

        public String getShow_viewPriv() {
            return this.show_viewPriv;
        }

        public void setShow_viewPriv(String show_viewPriv) {
            this.show_viewPriv = show_viewPriv;
        }

        public String getAlterPriv() {
            return this.alterPriv;
        }

        public void setAlterPriv(String alterPriv) {
            this.alterPriv = alterPriv;
        }

        public String getIndexPriv() {
            return this.indexPriv;
        }

        public void setIndexPriv(String indexPriv) {
            this.indexPriv = indexPriv;
        }

        public String getLockTablePriv() {
            return this.lockTablePriv;
        }

        public void setLockTablePriv(String lockTablePriv) {
            this.lockTablePriv = lockTablePriv;
        }
    }
}
