package cn.ctyun.apis.account;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询mysql保留关键字，即创建数据库或账号时禁用的关键字 */
public class Rds2GetInstanceKeywordsV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetInstanceKeywordsV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/account/instance-keywords",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetInstanceKeywordsV4Response send(
            Credential credential, GetInstanceKeywordsV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.queryType != null) {
            ctReq.addParam("queryType", request.queryType);
            request.queryType = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetInstanceKeywordsV4Response.class);
    }

    public static class GetInstanceKeywordsV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 必填参数。保留关键字的类型 account database */
        @JsonProperty("queryType")
        private String queryType;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getQueryType() {
            return this.queryType;
        }

        public void setQueryType(String queryType) {
            this.queryType = queryType;
        }
    }

    public static class GetInstanceKeywordsV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetInstanceKeywordsV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetInstanceKeywordsV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetInstanceKeywordsV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetInstanceKeywordsV4ReturnObjResponse {
        /** 查询类型 account database */
        @JsonProperty("queryType")
        private String queryType;

        private List<String> words;

        public String getQueryType() {
            return this.queryType;
        }

        public void setQueryType(String queryType) {
            this.queryType = queryType;
        }

        public List<String> getWords() {
            return this.words;
        }

        public void setWords(List<String> words) {
            this.words = words;
        }
    }
}
