package cn.ctyun.apis;

import cn.ctyun.apis.account.*;
import cn.ctyun.apis.database.*;
import cn.ctyun.apis.monitor.*;
import cn.ctyun.apis.notify.Rds2ConfirmNotifyV4Api;
import cn.ctyun.apis.notify.Rds2QueryNotifyV4Api;
import cn.ctyun.apis.parameter.*;
import cn.ctyun.apis.instance.*;
import cn.ctyun.apis.deadlock.*;
import cn.ctyun.apis.backup.*;
import cn.ctyun.apis.backup.v2.*;
import cn.ctyun.apis.proxysql.*;
import cn.ctyun.apis.security.*;
import cn.ctyun.apis.upgrade.*;
import cn.ctyun.apis.tag.*;
import cn.ctyun.apis.log.*;
import cn.ctyun.apis.common.*;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.Endpoint;

public class Apis {

    public static final String ENDPOINT_NAME = "rds2";



    public final Rds2ModifyInstanceTdeStatusApi rds2ModifyInstanceTdeStatusApi;
    public final Rds2DescDBInstanceSSLV4Api rds2DescDBInstanceSSLV4Api;
    public final Rds2GetInstanceTdeStatusApi rds2GetInstanceTdeStatusApi;
    public final Rds2DescribeBinlogFilesV4Api rds2DescribeBinlogFilesV4Api;
    public final Rds2ModifyInstanceSSLV4Api rds2ModifyInstanceSSLV4Api;
    public final Rds2CloudLogGrantApi rds2CloudLogGrantApi;
    public final Rds2CloudLogConfListApi rds2CloudLogConfListApi;
    public final Rds2CloudLogConfApi rds2CloudLogConfApi;
    public final Rds2ErrorLogListApi rds2ErrorLogListApi;
    public final Rds2FunctionCodeApi rds2FunctionCodeApi;
    public final Rds2GetOperationRecordApi rds2GetOperationRecordApi;
    public final Rds2DeleteCloudLogConfApi rds2DeleteCloudLogConfApi;
    public final Rds2CreateLogTaskApi rds2CreateLogTaskApi;
    public final Rds2SlowQueryFilesApi rds2SlowQueryFilesApi;
    public final Rds2GetLogDownloadLinkApi rds2GetLogDownloadLinkApi;
    public final Rds2CloudLogStreamApi rds2CloudLogStreamApi;
    public final Rds2CloudLogGroupsApi rds2CloudLogGroupsApi;
    public final Rds2GetEventsApi rds2GetEventsApi;

    public final Rds2GetOnlineResizeDiskApi rds2GetOnlineResizeDiskApi;
    public final Rds2GetAutoExpansionApi rds2GetAutoExpansionApi;
    public final Rds2ModifyAutoExpansionApi rds2ModifyAutoExpansionApi;
    public final Rds2ModifyDeletionProtectionApi rds2ModifyDeletionProtectionApi;
    public final Rds2ModifyFailoverTypeApi rds2ModifyFailoverTypeApi;
    public final Rds2GetAutomaticPerformanceScalingApi rds2GetAutomaticPerformanceScalingApi;
    public final Rds2SetAutomaticPerformanceScalingApi rds2SetAutomaticPerformanceScalingApi;
    public final Rds2ResetRootPasswordApi rds2ResetRootPasswordApi;
    public final Rds2SetInstReadOnlyOrReadWriteApi rds2SetInstReadOnlyOrReadWriteApi;
    public final Rds2SetReadonlyInstanceDelayReplicationTimeApi rds2SetReadonlyInstanceDelayReplicationTimeApi;
    public final Rds2GetHamodeTypeApi rds2GetHamodeTypeApi;
    public final Rds2ModifyHamodeTypeApi rds2ModifyHamodeTypeApi;
    public final Rds2RebuildInstanceApi rds2RebuildInstanceApi;

    public final Rds2CopyNewParameterGroupV4Api rds2CopyNewParameterGroupV4Api;

    public final Rds2DescribeParametersV4Api rds2DescribeParametersV4Api;

    public final Rds2ModifyRdsParameterV4Api rds2ModifyRdsParameterV4Api;
    public final Rds2DeleteParameterGroupV4Api rds2DeleteParameterGroupV4Api;

    public final Rds2FindAllParameterDetailsV4Api rds2FindAllParameterDetailsV4Api;

    public final Rds2FindAllParamTplV4Api rds2FindAllParamTplV4Api;

    public final Rds2ModifyParameterV4Api rds2ModifyParameterV4Api;
    public final Rds2CreateNewParameterGroupV4Api rds2CreateNewParameterGroupV4Api;

    public final Rds2GetKeyBufferSizeV4Api rds2GetKeyBufferSizeV4Api;

    public final Rds2GetMaxWriteLockCountV4Api rds2GetMaxWriteLockCountV4Api;

    public final Rds2GetMaxConnectErrorsV4Api rds2GetMaxConnectErrorsV4Api;
    public final Rds2SwitchVpcApi rds2SwitchVpcApi;
    public final Rds2SwitchDBInstanceHAV4Api rds2SwitchDBInstanceHAV4Api;
    public final Rds2SwitchableVpcListApi rds2SwitchableVpcListApi;
    public final Rds2ModifyHASwitchConfigV4Api rds2ModifyHASwitchConfigV4Api;
    public final Rds2ModifyDBInstanceDescriptionV4Api rds2ModifyDBInstanceDescriptionV4Api;
    public final Rds2GetAvailabilityZoneListApi rds2GetAvailabilityZoneListApi;
    public final Rds2DescribeHASwitchConfigV4Api rds2DescribeHASwitchConfigV4Api;
    public final Rds2AzMigrationApi rds2AzMigrationApi;
    public final Rds2ClearInstanceBinlogApi rds2ClearInstanceBinlogApi;
    public final Rds2ShowCharacterSetV4Api rds2ShowCharacterSetV4Api;
    public final Rds2QuerySchemaByProdIdV4Api rds2QuerySchemaByProdIdV4Api;
    public final Rds2ModifyDatabaseRemarksApi rds2ModifyDatabaseRemarksApi;
    public final Rds2DeleteDatabaseV4Api rds2DeleteDatabaseV4Api;
    public final Rds2CreateDatabaseV4Api rds2CreateDatabaseV4Api;
    public final Rds2CheckDBSchemaV4Api rds2CheckDBSchemaV4Api;

	// Account APIs
    public final Rds2CheckAccountAvailableApi rds2CheckAccountAvailableApi;
    public final Rds2CreateAccountV4Api rds2CreateAccountV4Api;
    public final Rds2DeleteAccountV4Api rds2DeleteAccountV4Api;
    public final Rds2GetInstanceKeywordsV4Api rds2GetInstanceKeywordsV4Api;
    public final Rds2GetUserAccountDetailV4Api rds2GetUserAccountDetailV4Api;
    public final Rds2GetUserAccountV4Api rds2GetUserAccountV4Api;
    public final Rds2GrantOperatorPrivilegeV4Api rds2GrantOperatorPrivilegeV4Api;
    public final Rds2ModifyAccountRemarkApi rds2ModifyAccountRemarkApi;
    public final Rds2ResetPasswordV4Api rds2ResetPasswordV4Api;
    public final Rds2ResetPrivilegeV4Api rds2ResetPrivilegeV4Api;
    public final Rds2RevokeOperatorPrivilegeV4Api rds2RevokeOperatorPrivilegeV4Api;

    // Tag APIs
    public final Rds2GetLabelsByProdInstIdApi rds2GetLabelsByProdInstIdApi;
    public final Rds2GetProjectIdByProdInstIdsApi rds2GetProjectIdByProdInstIdsApi;
    public final Rds2GetUserAllLabelsApi rds2GetUserAllLabelsApi;
    public final Rds2UpdateBatchLabelsWithProdInstIdApi rds2UpdateBatchLabelsWithProdInstIdApi;
    public final Rds2UpdateLabelsWithProdInstIdApi rds2UpdateLabelsWithProdInstIdApi;

    // backupRecovery
    public final Rds2CancelBackupApi rds2CancelBackupApi;
    public final Rds2CrossBinlogListApi rds2CrossBinlogListApi;
    public final Rds2CrossRecoveryApi rds2CrossRecoveryApi;
    public final Rds2DeleteBackupFileApi rds2DeleteBackupFileApi;
    public final Rds2GetBackupApi rds2GetBackupApi;
    public final Rds2GetBackupConfigApi rds2GetBackupConfigApi;
    public final Rds2GetBackupConfigListApi rds2GetBackupConfigListApi;
    public final Rds2GetBackupListApi rds2GetBackupListApi;
    public final Rds2GetCrossBakListApi rds2GetCrossBakListApi;
    public final Rds2GetCrossConfigApi rds2GetCrossConfigApi;
    public final Rds2GetCrossRegionApi rds2GetCrossRegionApi;
    public final Rds2GetOpenCrossBakInstsApi rds2GetOpenCrossBakInstsApi;
    public final Rds2PreCheckCrossBakInstsApi rds2PreCheckCrossBakInstsApi;
    public final Rds2UpdateBackupConfigApi rds2UpdateBackupConfigApi;
    public final Rds2UpdateCrossConfigApi rds2UpdateCrossConfigApi;


    public final Rds2BinlogDownloadApi rds2BinlogDownloadApi;
    public final Rds2CancelMergeApi rds2CancelMergeApi;
    public final Rds2CreateManualBackupApi rds2CreateManualBackupApi;
    public final Rds2CreateNewRecoveryJobApi rds2CreateNewRecoveryJobApi;
    public final Rds2GetBrRecoveryRecordDetailApi rds2GetBrRecoveryRecordDetailApi;
    public final Rds2GetBrRecoveryRecordListApi rds2GetBrRecoveryRecordListApi;
    public final Rds2GetListToBeRecoveryApi rds2GetListToBeRecoveryApi;
    public final Rds2GetRecoverableTimeRangeApi rds2GetRecoverableTimeRangeApi;
    public final Rds2GetSchemaByProdIdApi rds2GetSchemaByProdIdApi;
    public final Rds2GetSchemaTablesByProdIdApi rds2GetSchemaTablesByProdIdApi;
    public final Rds2GetZosObjDownloadLinkApi rds2GetZosObjDownloadLinkApi;
    public final Rds2MergeBinlogApi rds2MergeBinlogApi;
    public final Rds2MergeBinlogTaskDeleteApi rds2MergeBinlogTaskDeleteApi;
    public final Rds2MergeBinlogTaskListApi rds2MergeBinlogTaskListApi;
    public final Rds2MergedBinlogDeleteApi rds2MergedBinlogDeleteApi;
    public final Rds2RestoreTableApi rds2RestoreTableApi;
    public final Rds2BackupBinlogListApi rds2BackupBinlogListApi;
    public final Rds2DeadlockCountApi rds2DeadlockCountApi;
    public final Rds2DeadlockDetailApi rds2DeadlockDetailApi;

    public final Rds2DescParameterGroupV4Api rds2DescParameterGroupV4Api;


    public final Rds2ModifyRdsAccessWhiteListApi rds2ModifyRdsAccessWhiteListApi;
    public final Rds2DeleteRdsAccessWhiteListApi rds2DeleteRdsAccessWhiteListApi;
    public final Rds2CreateRdsAccessWhiteListApi rds2CreateRdsAccessWhiteListApi;
    public final Rds2GetRdsAccessWhiteListApi rds2GetRdsAccessWhiteListApi;
    public final Rds2UpgradeKernelVersionApi rds2UpgradeKernelVersionApi;
    public final Rds2UpgradeDBInstanceApi rds2UpgradeDBInstanceApi;

    public final Rds2DownloadCAApi rds2DownloadCAApi;
    public final Rds2AddFirewallSqlRuleApi rds2AddFirewallSqlRuleApi;
    public final Rds2ChangeAuditlogSwitchV2Api rds2ChangeAuditlogSwitchV2Api;
    public final Rds2DeleteFirewallSqlRuleApi rds2DeleteFirewallSqlRuleApi;
    public final Rds2FirewallSqlCheckStatusApi rds2FirewallSqlCheckStatusApi;
    public final Rds2GetAuditlogConfigV2Api rds2GetAuditlogConfigV2Api;
    public final Rds2GetAuditlogSwitchV2Api rds2GetAuditlogSwitchV2Api;
    public final Rds2GetErrorLogByProdInstIdV4Api rds2GetErrorLogByProdInstIdV4Api;
    public final Rds2GetFirewallSqlRuleApi rds2GetFirewallSqlRuleApi;
    public final Rds2GetSlowQueryDetailV4Api rds2GetSlowQueryDetailV4Api;
    public final Rds2GetSlowQueryByProdInstIdV4Api rds2GetSlowQueryByProdInstIdV4Api;
    public final Rds2ListAuditlogFilesV2Api rds2ListAuditlogFilesV2Api;
    public final Rds2ListFirewallSqlLogsApi rds2ListFirewallSqlLogsApi;
    public final Rds2ListFirewallSqlMigrableApi rds2ListFirewallSqlMigrableApi;
    public final Rds2MigrateFirewallSqlRuleApi rds2MigrateFirewallSqlRuleApi;
    public final Rds2SearchAuditlogFileV2Api rds2SearchAuditlogFileV2Api;
    public final Rds2UpdateAuditlogConfigV2Api rds2UpdateAuditlogConfigV2Api;


    public final Rds2GetInnodbOpenFilesV4Api rds2GetInnodbOpenFilesV4Api;
    public final Rds2GetLockWaitTimeoutV4Api rds2GetLockWaitTimeoutV4Api;
    public final Rds2GetLongQueryTimeV4Api rds2GetLongQueryTimeV4Api;
    public final Rds2GetMaxAllowedPacketV4Api rds2GetMaxAllowedPacketV4Api;
    public final Rds2GetParametersModifyHistoryV4Api rds2GetParametersModifyHistoryV4Api;

    public final Rds2DescDBInstanceMonitorV4Api rds2DescDBInstanceMonitorV4Api;
    public final Rds2GetInstanceUsageV4Api rds2GetInstanceUsageV4Api;
    public final Rds2GetInstancePerformanceV4Api rds2GetInstancePerformanceV4Api;
    public final Rds2ModifyInstanceMonitorFrequencyV4Api rds2ModifyInstanceMonitorFrequencyV4Api;
    public final Rds2GetMetricDataApi rds2GetMetricDataApi;

    public final Rds2ModifyDBInstanceWritePortV4Api rds2ModifyDBInstanceWritePortV4Api;
    public final Rds2SwitchInstanceRecordV4Api rds2SwitchInstanceRecordV4Api;
    public final Rds2ReadInstanceDelayV4Api rds2ReadInstanceDelayV4Api;
    public final Rds2ModifyEventPolicyV4Api rds2ModifyEventPolicyV4Api;
    public final Rds2GetTaskCenterEventsV4Api rds2GetTaskCenterEventsV4Api;
    public final Rds2GetTaskCenterSwV4Api rds2GetTaskCenterSwV4Api;
    public final Rds2GetInstanceHAConfigV4Api rds2GetInstanceHAConfigV4Api;
    public final Rds2GetInstanceNetInfoV4Api rds2GetInstanceNetInfoV4Api;
    public final Rds2GetInstanceByTimeV4Api rds2GetInstanceByTimeV4Api;

    public final Rds2ModifyMaintainableTimeApi rds2ModifyMaintainableTimeApi;
    public final Rds2QueryNodeInfosV4Api rds2QueryNodeInfosV4Api;
    public final Rds2RestartDBInstanceV4Api rds2RestartDBInstanceV4Api;
    public final Rds2GetInstanceListV4Api rds2GetInstanceListV4Api;
    public final Rds2QueryNotifyV4Api rds2QueryNotifyV4Api;
    public final Rds2ConfirmNotifyV4Api rds2ConfirmNotifyV4Api;

    public final Rds2StartDBInstance1V4Api rds2StartDBInstance1V4Api;
    public final Rds2StopDBInstance1V4Api rds2StopDBInstance1V4Api;
    public final Rds2GetInstanceDetailV4Api rds2GetInstanceDetailV4Api;
    public final Rds2CheckInstanceExistV4Api rds2CheckInstanceExistV4Api;

    public final Rds2QueryProxyEndpointApi rds2QueryProxyEndpointApi;
    public final Rds2GetProxyHealthInfoApi rds2GetProxyHealthInfoApi;
    public final Rds2ConfigProxyApi rds2ConfigProxyApi;
    public final Rds2QueryProxyInstanceDetailApi rds2QueryProxyInstanceDetailApi;
    public final Rds2GetProxySslDetailApi rds2GetProxySslDetailApi;
    public final Rds2ModifyProxySslStatusApi rds2ModifyProxySslStatusApi;

    public final Rds2UpgradeV2Api rds2UpgradeV2Api;
    public  final Rds2AcceptV2Api rds2AcceptV2Api;
    public final Rds2TemplateV2Api rds2TemplateV2Api;
    public final Rds2RegionInfoV2Api rds2RegionInfoV2Api;
    public final Rds2RefundOrderV2Api rds2RefundOrderV2Api;
    public final Rds2DestroyOrderApi rds2DestroyOrderApi;
    public final Rds2RenewOrderV2Api rds2RenewOrderV2Api;
    public final Rds2DegradeV2Api rds2DegradeV2Api;
    public final Rds2AvailabilityZoneV2Api rds2AvailabilityZoneV2Api;
    public final Rds2SecurityGroupV2Api rds2SecurityGroupV2Api;
    public final Rds2UnbindV2Api rds2UnbindV2Api;
    public final Rds2EipsV2Api rds2EipsV2Api;
    public final Rds2BindV2Api rds2BindV2Api;
    public final Rds2InquiryForUpgradeV2Api rds2InquiryForUpgradeV2Api;
    public final Rds2InquiryV2Api rds2InquiryV2Api;
    public final Rds2ListV2Api rds2ListV2Api;
    public final Rds2InquiryForRenewOrderApi rds2InquiryForRenewOrderApi;

    public final Rds2GetInstStateApi rds2GetInstStateApi;
    public final Rds2GetInstIdByOrderIdApi rds2GetInstIdByOrderIdApi;
    public final Rds2GetPublicKeyApi rds2GetPublicKeyApi;
    public final Rds2MetricsApi rds2MetricsApi;
    public final Rds2InstMetricDataBatchApi rds2InstMetricDataBatchApi;
    public final Rds2ChangeV2Api rds2ChangeV2Api;
    public final Rds2InstMetricDataApi rds2InstMetricDataApi;

    public Apis(String endpointUrl, CtyunClient ctyunClient) {
        ctyunClient.registerEndpoint(new Endpoint(ENDPOINT_NAME, endpointUrl));


        this.rds2ModifyInstanceTdeStatusApi = new Rds2ModifyInstanceTdeStatusApi(ctyunClient);
        this.rds2DescDBInstanceSSLV4Api = new Rds2DescDBInstanceSSLV4Api(ctyunClient);
        this.rds2GetInstanceTdeStatusApi = new Rds2GetInstanceTdeStatusApi(ctyunClient);
        this.rds2DescribeBinlogFilesV4Api = new Rds2DescribeBinlogFilesV4Api(ctyunClient);
        this.rds2ModifyInstanceSSLV4Api = new Rds2ModifyInstanceSSLV4Api(ctyunClient);
        this.rds2CloudLogGrantApi = new Rds2CloudLogGrantApi(ctyunClient);
        this.rds2CloudLogConfListApi = new Rds2CloudLogConfListApi(ctyunClient);
        this.rds2CloudLogConfApi = new Rds2CloudLogConfApi(ctyunClient);
        this.rds2ErrorLogListApi = new Rds2ErrorLogListApi(ctyunClient);
        this.rds2FunctionCodeApi = new Rds2FunctionCodeApi(ctyunClient);
        this.rds2GetOperationRecordApi = new Rds2GetOperationRecordApi(ctyunClient);
        this.rds2DeleteCloudLogConfApi = new Rds2DeleteCloudLogConfApi(ctyunClient);
        this.rds2CreateLogTaskApi = new Rds2CreateLogTaskApi(ctyunClient);
        this.rds2SlowQueryFilesApi = new Rds2SlowQueryFilesApi(ctyunClient);
        this.rds2GetLogDownloadLinkApi = new Rds2GetLogDownloadLinkApi(ctyunClient);
        this.rds2CloudLogStreamApi = new Rds2CloudLogStreamApi(ctyunClient);
        this.rds2CloudLogGroupsApi = new Rds2CloudLogGroupsApi(ctyunClient);
        this.rds2GetOnlineResizeDiskApi = new Rds2GetOnlineResizeDiskApi(ctyunClient);
        this.rds2GetAutoExpansionApi = new Rds2GetAutoExpansionApi(ctyunClient);
        this.rds2ModifyAutoExpansionApi = new Rds2ModifyAutoExpansionApi(ctyunClient);
        this.rds2ModifyDeletionProtectionApi = new Rds2ModifyDeletionProtectionApi(ctyunClient);
        this.rds2ModifyFailoverTypeApi = new Rds2ModifyFailoverTypeApi(ctyunClient);
        this.rds2GetAutomaticPerformanceScalingApi = new Rds2GetAutomaticPerformanceScalingApi(ctyunClient);
        this.rds2SetAutomaticPerformanceScalingApi = new Rds2SetAutomaticPerformanceScalingApi(ctyunClient);
        this.rds2ResetRootPasswordApi = new Rds2ResetRootPasswordApi(ctyunClient);
        this.rds2SetInstReadOnlyOrReadWriteApi = new Rds2SetInstReadOnlyOrReadWriteApi(ctyunClient);
        this.rds2SetReadonlyInstanceDelayReplicationTimeApi = new Rds2SetReadonlyInstanceDelayReplicationTimeApi(ctyunClient);
        this.rds2GetHamodeTypeApi = new Rds2GetHamodeTypeApi(ctyunClient);
        this.rds2ModifyHamodeTypeApi = new Rds2ModifyHamodeTypeApi(ctyunClient);
        this.rds2RebuildInstanceApi = new Rds2RebuildInstanceApi(ctyunClient);
        this.rds2GetEventsApi = new Rds2GetEventsApi(ctyunClient);

        this.rds2CopyNewParameterGroupV4Api = new Rds2CopyNewParameterGroupV4Api(ctyunClient);
        this.rds2DescribeParametersV4Api = new Rds2DescribeParametersV4Api(ctyunClient);
        this.rds2ModifyRdsParameterV4Api = new Rds2ModifyRdsParameterV4Api(ctyunClient);
        this.rds2DeleteParameterGroupV4Api = new Rds2DeleteParameterGroupV4Api(ctyunClient);
        this.rds2FindAllParameterDetailsV4Api = new Rds2FindAllParameterDetailsV4Api(ctyunClient);
        this.rds2FindAllParamTplV4Api = new Rds2FindAllParamTplV4Api(ctyunClient);
        this.rds2ModifyParameterV4Api = new Rds2ModifyParameterV4Api(ctyunClient);
        this.rds2CreateNewParameterGroupV4Api = new Rds2CreateNewParameterGroupV4Api(ctyunClient);
        this.rds2GetKeyBufferSizeV4Api = new Rds2GetKeyBufferSizeV4Api(ctyunClient);
        this.rds2GetMaxWriteLockCountV4Api = new Rds2GetMaxWriteLockCountV4Api(ctyunClient);
        this.rds2GetMaxConnectErrorsV4Api = new Rds2GetMaxConnectErrorsV4Api(ctyunClient);
        this.rds2DescParameterGroupV4Api = new Rds2DescParameterGroupV4Api(ctyunClient);

        this.rds2SwitchVpcApi = new Rds2SwitchVpcApi(ctyunClient);
        this.rds2SwitchDBInstanceHAV4Api = new Rds2SwitchDBInstanceHAV4Api(ctyunClient);
        this.rds2SwitchableVpcListApi = new Rds2SwitchableVpcListApi(ctyunClient);
        this.rds2ModifyHASwitchConfigV4Api = new Rds2ModifyHASwitchConfigV4Api(ctyunClient);
        this.rds2ModifyDBInstanceDescriptionV4Api = new Rds2ModifyDBInstanceDescriptionV4Api(ctyunClient);
        this.rds2GetAvailabilityZoneListApi = new Rds2GetAvailabilityZoneListApi(ctyunClient);
        this.rds2DescribeHASwitchConfigV4Api = new Rds2DescribeHASwitchConfigV4Api(ctyunClient);
        this.rds2AzMigrationApi = new Rds2AzMigrationApi(ctyunClient);
        this.rds2ClearInstanceBinlogApi = new Rds2ClearInstanceBinlogApi(ctyunClient);
        this.rds2ShowCharacterSetV4Api = new Rds2ShowCharacterSetV4Api(ctyunClient);
        this.rds2QuerySchemaByProdIdV4Api = new Rds2QuerySchemaByProdIdV4Api(ctyunClient);
        this.rds2ModifyDatabaseRemarksApi = new Rds2ModifyDatabaseRemarksApi(ctyunClient);
        this.rds2DeleteDatabaseV4Api = new Rds2DeleteDatabaseV4Api(ctyunClient);
        this.rds2CreateDatabaseV4Api = new Rds2CreateDatabaseV4Api(ctyunClient);
        this.rds2CheckDBSchemaV4Api = new Rds2CheckDBSchemaV4Api(ctyunClient);

		// Initialize Account APIs
        this.rds2CheckAccountAvailableApi = new Rds2CheckAccountAvailableApi(ctyunClient);
        this.rds2CreateAccountV4Api = new Rds2CreateAccountV4Api(ctyunClient);
        this.rds2DeleteAccountV4Api = new Rds2DeleteAccountV4Api(ctyunClient);
        this.rds2GetInstanceKeywordsV4Api = new Rds2GetInstanceKeywordsV4Api(ctyunClient);
        this.rds2GetUserAccountDetailV4Api = new Rds2GetUserAccountDetailV4Api(ctyunClient);
        this.rds2GetUserAccountV4Api = new Rds2GetUserAccountV4Api(ctyunClient);
        this.rds2GrantOperatorPrivilegeV4Api = new Rds2GrantOperatorPrivilegeV4Api(ctyunClient);
        this.rds2ModifyAccountRemarkApi = new Rds2ModifyAccountRemarkApi(ctyunClient);
        this.rds2ResetPasswordV4Api = new Rds2ResetPasswordV4Api(ctyunClient);
        this.rds2ResetPrivilegeV4Api = new Rds2ResetPrivilegeV4Api(ctyunClient);
        this.rds2RevokeOperatorPrivilegeV4Api = new Rds2RevokeOperatorPrivilegeV4Api(ctyunClient);

        // Initialize Tag APIs
        this.rds2GetLabelsByProdInstIdApi = new Rds2GetLabelsByProdInstIdApi(ctyunClient);
        this.rds2GetProjectIdByProdInstIdsApi = new Rds2GetProjectIdByProdInstIdsApi(ctyunClient);
        this.rds2GetUserAllLabelsApi = new Rds2GetUserAllLabelsApi(ctyunClient);
        this.rds2UpdateBatchLabelsWithProdInstIdApi = new Rds2UpdateBatchLabelsWithProdInstIdApi(ctyunClient);
        this.rds2UpdateLabelsWithProdInstIdApi = new Rds2UpdateLabelsWithProdInstIdApi(ctyunClient);

        // Initialize BackupRecovery APIS

        // backupRecovery
        this.rds2CancelBackupApi = new Rds2CancelBackupApi(ctyunClient);
        this.rds2CrossBinlogListApi = new Rds2CrossBinlogListApi(ctyunClient);
        this.rds2CrossRecoveryApi = new Rds2CrossRecoveryApi(ctyunClient);
        this.rds2DeleteBackupFileApi = new Rds2DeleteBackupFileApi(ctyunClient);
        this.rds2GetBackupApi = new Rds2GetBackupApi(ctyunClient);
        this.rds2GetBackupConfigApi = new Rds2GetBackupConfigApi(ctyunClient);
        this.rds2GetBackupConfigListApi = new Rds2GetBackupConfigListApi(ctyunClient);
        this.rds2GetBackupListApi = new Rds2GetBackupListApi(ctyunClient);
        this.rds2GetCrossBakListApi = new Rds2GetCrossBakListApi(ctyunClient);
        this.rds2GetCrossConfigApi = new Rds2GetCrossConfigApi(ctyunClient);
        this.rds2GetCrossRegionApi = new Rds2GetCrossRegionApi(ctyunClient);
        this.rds2GetOpenCrossBakInstsApi = new Rds2GetOpenCrossBakInstsApi(ctyunClient);
        this.rds2PreCheckCrossBakInstsApi = new Rds2PreCheckCrossBakInstsApi(ctyunClient);
        this.rds2UpdateBackupConfigApi = new Rds2UpdateBackupConfigApi(ctyunClient);
        this.rds2UpdateCrossConfigApi = new Rds2UpdateCrossConfigApi(ctyunClient);

        this.rds2BinlogDownloadApi = new Rds2BinlogDownloadApi(ctyunClient);
        this.rds2CancelMergeApi = new Rds2CancelMergeApi(ctyunClient);
        this.rds2CreateManualBackupApi = new Rds2CreateManualBackupApi(ctyunClient);
        this.rds2CreateNewRecoveryJobApi = new Rds2CreateNewRecoveryJobApi(ctyunClient);
        this.rds2GetBrRecoveryRecordDetailApi = new Rds2GetBrRecoveryRecordDetailApi(ctyunClient);
        this.rds2GetBrRecoveryRecordListApi = new Rds2GetBrRecoveryRecordListApi(ctyunClient);
        this.rds2GetListToBeRecoveryApi = new Rds2GetListToBeRecoveryApi(ctyunClient);
        this.rds2GetRecoverableTimeRangeApi = new Rds2GetRecoverableTimeRangeApi(ctyunClient);
        this.rds2GetSchemaByProdIdApi = new Rds2GetSchemaByProdIdApi(ctyunClient);
        this.rds2GetSchemaTablesByProdIdApi = new Rds2GetSchemaTablesByProdIdApi(ctyunClient);
        this.rds2GetZosObjDownloadLinkApi = new Rds2GetZosObjDownloadLinkApi(ctyunClient);
        this.rds2MergeBinlogApi = new Rds2MergeBinlogApi(ctyunClient);
        this.rds2MergeBinlogTaskDeleteApi = new Rds2MergeBinlogTaskDeleteApi(ctyunClient);
        this.rds2MergeBinlogTaskListApi = new Rds2MergeBinlogTaskListApi(ctyunClient);
        this.rds2MergedBinlogDeleteApi = new Rds2MergedBinlogDeleteApi(ctyunClient);
        this.rds2RestoreTableApi = new Rds2RestoreTableApi(ctyunClient);
        this.rds2BackupBinlogListApi = new Rds2BackupBinlogListApi(ctyunClient);
        this.rds2DeadlockCountApi = new Rds2DeadlockCountApi(ctyunClient);
        this.rds2DeadlockDetailApi = new Rds2DeadlockDetailApi(ctyunClient);

        this.rds2UpgradeKernelVersionApi = new Rds2UpgradeKernelVersionApi(ctyunClient);
        this.rds2UpgradeDBInstanceApi = new Rds2UpgradeDBInstanceApi(ctyunClient);

        this.rds2ModifyRdsAccessWhiteListApi = new Rds2ModifyRdsAccessWhiteListApi(ctyunClient);
        this.rds2DeleteRdsAccessWhiteListApi = new Rds2DeleteRdsAccessWhiteListApi(ctyunClient);
        this.rds2CreateRdsAccessWhiteListApi = new Rds2CreateRdsAccessWhiteListApi(ctyunClient);
        this.rds2GetRdsAccessWhiteListApi = new Rds2GetRdsAccessWhiteListApi(ctyunClient);

        this.rds2DownloadCAApi = new Rds2DownloadCAApi(ctyunClient);
        this.rds2AddFirewallSqlRuleApi = new Rds2AddFirewallSqlRuleApi(ctyunClient);
        this.rds2ChangeAuditlogSwitchV2Api = new Rds2ChangeAuditlogSwitchV2Api(ctyunClient);
        this.rds2DeleteFirewallSqlRuleApi = new Rds2DeleteFirewallSqlRuleApi(ctyunClient);
        this.rds2FirewallSqlCheckStatusApi = new Rds2FirewallSqlCheckStatusApi(ctyunClient);
        this.rds2GetAuditlogConfigV2Api = new Rds2GetAuditlogConfigV2Api(ctyunClient);
        this.rds2GetAuditlogSwitchV2Api = new Rds2GetAuditlogSwitchV2Api(ctyunClient);
        this.rds2GetErrorLogByProdInstIdV4Api = new Rds2GetErrorLogByProdInstIdV4Api(ctyunClient);
        this.rds2GetFirewallSqlRuleApi = new Rds2GetFirewallSqlRuleApi(ctyunClient);
        this.rds2GetSlowQueryDetailV4Api = new Rds2GetSlowQueryDetailV4Api(ctyunClient);
        this.rds2GetSlowQueryByProdInstIdV4Api = new Rds2GetSlowQueryByProdInstIdV4Api(ctyunClient);
        this.rds2ListAuditlogFilesV2Api = new Rds2ListAuditlogFilesV2Api(ctyunClient);
        this.rds2ListFirewallSqlLogsApi = new Rds2ListFirewallSqlLogsApi(ctyunClient);
        this.rds2ListFirewallSqlMigrableApi = new Rds2ListFirewallSqlMigrableApi(ctyunClient);
        this.rds2MigrateFirewallSqlRuleApi = new Rds2MigrateFirewallSqlRuleApi(ctyunClient);
        this.rds2SearchAuditlogFileV2Api = new Rds2SearchAuditlogFileV2Api(ctyunClient);
        this.rds2UpdateAuditlogConfigV2Api = new Rds2UpdateAuditlogConfigV2Api(ctyunClient);

        this.rds2GetInnodbOpenFilesV4Api = new Rds2GetInnodbOpenFilesV4Api(ctyunClient);
        this.rds2GetLockWaitTimeoutV4Api = new Rds2GetLockWaitTimeoutV4Api(ctyunClient);
        this.rds2GetLongQueryTimeV4Api = new Rds2GetLongQueryTimeV4Api(ctyunClient);
        this.rds2GetMaxAllowedPacketV4Api = new Rds2GetMaxAllowedPacketV4Api(ctyunClient);
        this.rds2GetParametersModifyHistoryV4Api = new Rds2GetParametersModifyHistoryV4Api(ctyunClient);

        this.rds2DescDBInstanceMonitorV4Api = new Rds2DescDBInstanceMonitorV4Api(ctyunClient);
        this.rds2GetInstanceUsageV4Api = new Rds2GetInstanceUsageV4Api(ctyunClient);
        this.rds2GetInstancePerformanceV4Api = new Rds2GetInstancePerformanceV4Api(ctyunClient);
        this.rds2ModifyInstanceMonitorFrequencyV4Api = new Rds2ModifyInstanceMonitorFrequencyV4Api(ctyunClient);
        this.rds2GetMetricDataApi = new Rds2GetMetricDataApi(ctyunClient);


        this.rds2ModifyDBInstanceWritePortV4Api =
                new Rds2ModifyDBInstanceWritePortV4Api(ctyunClient);
        this.rds2SwitchInstanceRecordV4Api = new Rds2SwitchInstanceRecordV4Api(ctyunClient);
        this.rds2ReadInstanceDelayV4Api = new Rds2ReadInstanceDelayV4Api(ctyunClient);
        this.rds2ModifyEventPolicyV4Api = new Rds2ModifyEventPolicyV4Api(ctyunClient);
        this.rds2GetTaskCenterEventsV4Api = new Rds2GetTaskCenterEventsV4Api(ctyunClient);
        this.rds2GetTaskCenterSwV4Api = new Rds2GetTaskCenterSwV4Api(ctyunClient);
        this.rds2GetInstanceHAConfigV4Api = new Rds2GetInstanceHAConfigV4Api(ctyunClient);
        this.rds2GetInstanceNetInfoV4Api = new Rds2GetInstanceNetInfoV4Api(ctyunClient);
        this.rds2GetInstanceByTimeV4Api = new Rds2GetInstanceByTimeV4Api(ctyunClient);

        this.rds2ModifyMaintainableTimeApi = new Rds2ModifyMaintainableTimeApi(ctyunClient);
        this.rds2QueryNodeInfosV4Api = new Rds2QueryNodeInfosV4Api(ctyunClient);
        this.rds2RestartDBInstanceV4Api = new Rds2RestartDBInstanceV4Api(ctyunClient);
        this.rds2GetInstanceListV4Api = new Rds2GetInstanceListV4Api(ctyunClient);
        this.rds2QueryNotifyV4Api = new Rds2QueryNotifyV4Api(ctyunClient);
        this.rds2ConfirmNotifyV4Api = new Rds2ConfirmNotifyV4Api(ctyunClient);

        this.rds2StartDBInstance1V4Api = new Rds2StartDBInstance1V4Api(ctyunClient);
        this.rds2StopDBInstance1V4Api = new Rds2StopDBInstance1V4Api(ctyunClient);
        this.rds2GetInstanceDetailV4Api = new Rds2GetInstanceDetailV4Api(ctyunClient);
        this.rds2CheckInstanceExistV4Api = new Rds2CheckInstanceExistV4Api(ctyunClient);

        this.rds2QueryProxyEndpointApi = new Rds2QueryProxyEndpointApi(ctyunClient);
        this.rds2GetProxyHealthInfoApi = new Rds2GetProxyHealthInfoApi(ctyunClient);
        this.rds2ConfigProxyApi = new Rds2ConfigProxyApi(ctyunClient);
        this.rds2QueryProxyInstanceDetailApi = new Rds2QueryProxyInstanceDetailApi(ctyunClient);
        this.rds2GetProxySslDetailApi = new Rds2GetProxySslDetailApi(ctyunClient);
        this.rds2ModifyProxySslStatusApi = new Rds2ModifyProxySslStatusApi(ctyunClient);

        this.rds2RenewOrderV2Api = new Rds2RenewOrderV2Api(ctyunClient);
        this.rds2DestroyOrderApi = new Rds2DestroyOrderApi(ctyunClient);
        this.rds2RefundOrderV2Api = new Rds2RefundOrderV2Api(ctyunClient);
        this.rds2RegionInfoV2Api = new Rds2RegionInfoV2Api(ctyunClient);
        this.rds2UpgradeV2Api = new Rds2UpgradeV2Api(ctyunClient);
        this.rds2TemplateV2Api = new Rds2TemplateV2Api(ctyunClient);
        this.rds2AcceptV2Api = new Rds2AcceptV2Api(ctyunClient);
        this.rds2DegradeV2Api = new Rds2DegradeV2Api(ctyunClient);
        this.rds2AvailabilityZoneV2Api = new Rds2AvailabilityZoneV2Api(ctyunClient);
        this.rds2SecurityGroupV2Api = new Rds2SecurityGroupV2Api(ctyunClient);

        this.rds2UnbindV2Api=new Rds2UnbindV2Api(ctyunClient);
        this.rds2BindV2Api=new Rds2BindV2Api(ctyunClient);
        this.rds2EipsV2Api=new Rds2EipsV2Api(ctyunClient);
        this.rds2InquiryForUpgradeV2Api=new Rds2InquiryForUpgradeV2Api(ctyunClient);
        this.rds2InquiryV2Api=new Rds2InquiryV2Api(ctyunClient);
        this.rds2ListV2Api=new Rds2ListV2Api(ctyunClient);
        this.rds2InquiryForRenewOrderApi=new Rds2InquiryForRenewOrderApi(ctyunClient);
        this.rds2GetInstStateApi=new Rds2GetInstStateApi(ctyunClient);
        this.rds2GetInstIdByOrderIdApi=new Rds2GetInstIdByOrderIdApi(ctyunClient);
        this.rds2GetPublicKeyApi=new Rds2GetPublicKeyApi(ctyunClient);
        this.rds2MetricsApi=new Rds2MetricsApi(ctyunClient);
        this.rds2InstMetricDataBatchApi=new Rds2InstMetricDataBatchApi(ctyunClient);
        this.rds2ChangeV2Api=new Rds2ChangeV2Api(ctyunClient);
        this.rds2InstMetricDataApi=new Rds2InstMetricDataApi(ctyunClient);
    }
}
