
package com.ctyun.openapisdk.request;
import com.ctyun.openapisdk.core.models.CtyunOpenAPIRequest;
import java.util.*;

/**
 * V41MonitorUpdateAlarmRule请求类
 * 此文件由天翼云SDK工具自动生成,请勿修改
 */
public class V41MonitorUpdateAlarmRuleRequest extends CtyunOpenAPIRequest {

    /**
     * alarmRuleID
     * require: true
     * description: 告警规则ID
     */
    private String alarmRuleID;
    /**
     * regionID
     * require: true
     * description: 资源池ID
     */
    private String regionID;
    /**
     * name
     * require: true
     * description: 规则名
     */
    private String name;
    /**
     * service
     * require: true
     * description: 本参数表示服务。取值范围：<br>ecs：云主机。<br>evs：云硬盘。<br>pms：物理机。<br>...<br>详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
     */
    private String service;
    /**
     * dimension
     * require: true
     * description: 本参数表示告警维度。取值范围：<br>ecs：云主机。<br>disk：磁盘。<br>pms：物理机。<br>...<br>详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
     */
    private String dimension;
    /**
     * conditions
     * require: true
     * description: 具体告警匹配策略
     */
    private List<V41MonitorUpdateAlarmRuleConditions> conditions;
    /**
     * desc
     * require: false
     * description: 规则描述
     */
    private String desc;
    /**
     * repeatTimes
     * require: false
     * description: 重复告警通知次数，默认为0，当repeatTimes值为-1，代表无限重复。
     */
    private Integer repeatTimes;
    /**
     * silenceTime
     * require: false
     * description: 告警接收策略静默时间，多久重复通知一次，单位：秒
     */
    private Integer silenceTime;
    /**
     * recoverNotify
     * require: false
     * description: 本参数表示恢复是否通知。默认值0。取值范围：<br>0：否。<br>1：是。<br>根据以上范围取值。
     */
    private Integer recoverNotify;
    /**
     * notifyType
     * require: false
     * description: 本参数表示告警接收策略。取值范围：<br>email：邮件告警。<br>sms：短信告警。<br>根据以上范围取值。
     */
    private List<String> notifyType;
    /**
     * contactGroupList
     * require: false
     * description: 告警联系组
     */
    private List<String> contactGroupList;
    /**
     * notifyWeekdays
     * require: false
     * description: 本参数表示通知周期。默认值[0,1,2,3,4,5,6]。取值范围：<br>0：周日。<br>1：周一。<br>2：周二。<br>3：周三。<br>4：周四。<br>5：周五。<br>6：周六。<br>根据以上范围取值。
     */
    private List<Integer> notifyWeekdays;
    /**
     * notifyStart
     * require: false
     * description: 通知起始时段，默认为00:00:00
     */
    private String notifyStart;
    /**
     * notifyEnd
     * require: false
     * description: 通知结束时段，默认为23:59:59
     */
    private String notifyEnd;
    /**
     * webhookUrl
     * require: false
     * description: webhook消息推送url
     */
    private List<String> webhookUrl;
    /**
     * resGroupID
     * require: false
     * description: 资源分组ID，与resources字段互斥。<br>&#32;1.以资源分组为资源对象的告警规则，不需要传入resources。<br>2\.非资源分组为资源对象的告警规则，resources为必填项。
     */
    private String resGroupID;
    /**
     * resources
     * require: true
     * description: 具体告警匹配资源
     */
    private List<V41MonitorUpdateAlarmRuleResources> resources;
    /**
     * projectID
     * require: false
     * description: 项目ID
     */
    private String projectID;
    /**
     * conditionType
     * require: false
     * description: 本参数表示告警策略触发类型。默认值0。取值范围：<br>0：或，任一条件触发。<br>1：全部条件满足触发。<br>根据以上范围取值。
     */
    private Integer conditionType;
    /**
     * resourceScope
     * require: false
     * description: 规则的资源范围，默认值0，取值范围：<br>0：实例资源类型。<br>1：资源分组类型。<br>2：全部资源类型 。 <br>根据以上范围取值。
     */
    private Integer resourceScope;
    /**
     * defaultContact
     * require: false
     * description: 是否使用天翼云默认联系人接收通知，默认值0，取值范围：<br>0：否。<br>1：是。 <br>根据以上范围取值。
     */
    private Integer defaultContact;
    /**
     * noticeStrategyID
     * require: false
     * description: 通知策略ID
     */
    private String noticeStrategyID;


    public String getAlarmRuleID() {
        return alarmRuleID;
    }

    public V41MonitorUpdateAlarmRuleRequest setAlarmRuleID(String alarmRuleID) {
        this.alarmRuleID = alarmRuleID;
        return this;
    }
    
    public String getRegionID() {
        return regionID;
    }

    public V41MonitorUpdateAlarmRuleRequest setRegionID(String regionID) {
        this.regionID = regionID;
        return this;
    }
    
    public String getName() {
        return name;
    }

    public V41MonitorUpdateAlarmRuleRequest setName(String name) {
        this.name = name;
        return this;
    }
    
    public String getService() {
        return service;
    }

    public V41MonitorUpdateAlarmRuleRequest setService(String service) {
        this.service = service;
        return this;
    }
    
    public String getDimension() {
        return dimension;
    }

    public V41MonitorUpdateAlarmRuleRequest setDimension(String dimension) {
        this.dimension = dimension;
        return this;
    }
    
    public List<V41MonitorUpdateAlarmRuleConditions> getConditions() {
        return conditions;
    }

    public V41MonitorUpdateAlarmRuleRequest setConditions(List<V41MonitorUpdateAlarmRuleConditions> conditions) {
        this.conditions = conditions;
        return this;
    }


    public String getDesc() {
        return desc;
    }

    public V41MonitorUpdateAlarmRuleRequest setDesc(String desc) {
        this.desc = desc;
        return this;
    }
    
    public Integer getRepeatTimes() {
        return repeatTimes;
    }

    public V41MonitorUpdateAlarmRuleRequest setRepeatTimes(Integer repeatTimes) {
        this.repeatTimes = repeatTimes;
        return this;
    }
    
    public Integer getSilenceTime() {
        return silenceTime;
    }

    public V41MonitorUpdateAlarmRuleRequest setSilenceTime(Integer silenceTime) {
        this.silenceTime = silenceTime;
        return this;
    }
    
    public Integer getRecoverNotify() {
        return recoverNotify;
    }

    public V41MonitorUpdateAlarmRuleRequest setRecoverNotify(Integer recoverNotify) {
        this.recoverNotify = recoverNotify;
        return this;
    }
    
    public List<String> getNotifyType() {
        return notifyType;
    }

    public V41MonitorUpdateAlarmRuleRequest setNotifyType(List<String> notifyType) {
        this.notifyType = notifyType;
        return this;
    }


    public List<String> getContactGroupList() {
        return contactGroupList;
    }

    public V41MonitorUpdateAlarmRuleRequest setContactGroupList(List<String> contactGroupList) {
        this.contactGroupList = contactGroupList;
        return this;
    }


    public List<Integer> getNotifyWeekdays() {
        return notifyWeekdays;
    }

    public V41MonitorUpdateAlarmRuleRequest setNotifyWeekdays(List<Integer> notifyWeekdays) {
        this.notifyWeekdays = notifyWeekdays;
        return this;
    }


    public String getNotifyStart() {
        return notifyStart;
    }

    public V41MonitorUpdateAlarmRuleRequest setNotifyStart(String notifyStart) {
        this.notifyStart = notifyStart;
        return this;
    }
    
    public String getNotifyEnd() {
        return notifyEnd;
    }

    public V41MonitorUpdateAlarmRuleRequest setNotifyEnd(String notifyEnd) {
        this.notifyEnd = notifyEnd;
        return this;
    }
    
    public List<String> getWebhookUrl() {
        return webhookUrl;
    }

    public V41MonitorUpdateAlarmRuleRequest setWebhookUrl(List<String> webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }


    public String getResGroupID() {
        return resGroupID;
    }

    public V41MonitorUpdateAlarmRuleRequest setResGroupID(String resGroupID) {
        this.resGroupID = resGroupID;
        return this;
    }
    
    public List<V41MonitorUpdateAlarmRuleResources> getResources() {
        return resources;
    }

    public V41MonitorUpdateAlarmRuleRequest setResources(List<V41MonitorUpdateAlarmRuleResources> resources) {
        this.resources = resources;
        return this;
    }


    public String getProjectID() {
        return projectID;
    }

    public V41MonitorUpdateAlarmRuleRequest setProjectID(String projectID) {
        this.projectID = projectID;
        return this;
    }
    
    public Integer getConditionType() {
        return conditionType;
    }

    public V41MonitorUpdateAlarmRuleRequest setConditionType(Integer conditionType) {
        this.conditionType = conditionType;
        return this;
    }
    
    public Integer getResourceScope() {
        return resourceScope;
    }

    public V41MonitorUpdateAlarmRuleRequest setResourceScope(Integer resourceScope) {
        this.resourceScope = resourceScope;
        return this;
    }
    
    public Integer getDefaultContact() {
        return defaultContact;
    }

    public V41MonitorUpdateAlarmRuleRequest setDefaultContact(Integer defaultContact) {
        this.defaultContact = defaultContact;
        return this;
    }
    
    public String getNoticeStrategyID() {
        return noticeStrategyID;
    }

    public V41MonitorUpdateAlarmRuleRequest setNoticeStrategyID(String noticeStrategyID) {
        this.noticeStrategyID = noticeStrategyID;
        return this;
    }
    
}