
package com.ctyun.openapisdk.request;
import com.ctyun.openapisdk.core.models.CtyunOpenAPIRequest;
import java.util.*;

/**
 * V4EbmRenew请求类
 * 此文件由天翼云SDK工具自动生成,请勿修改
 */
public class V4EbmRenewRequest extends CtyunOpenAPIRequest {

    /**
     * regionID
     * require: true
     * description: 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10026730/10028695">地域和可用区</a>来了解资源池<br/>您可以调用<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81">资源池列表查询</a>获取最新的天翼云资源池列表
     */

    private String regionID;


    /**
     * azName
     * require: true
     * description: 可用区名称，您可以查看地域和可用区来了解可用区<br/>您可以调用<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5855&data=87">资源池可用区查询</a><br/>注：查询结果中zoneList内返回存在可用区名称(即多可用区，本字段填写实际可用区名称)，若查询结果中zoneList为空（即为单可用区，本字段填写default）
     */

    private String azName;


    /**
     * instanceUUID
     * require: true
     * description: 实例UUID，您可以调用<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=9715&data=87&isNormal=1">根据订单号查询uuid</a>获取实例UUID
     */

    private String instanceUUID;


    /**
     * payVoucherPrice
     * require: false
     * description: 代金券，满足以下规则：两位小数，不足两位自动补0，超过两位小数无效；不可为负数；字段为0时表示不使用代金券
     */

    private Float payVoucherPrice;


    /**
     * cycleType
     * require: true
     * description: 订购周期类型，取值范围:[MONTH=按月,YEAR=按年]<br/>注：cycleType与cycleCount一起填写
     */

    private String cycleType;


    /**
     * cycleCount
     * require: true
     * description: 订购时长，该参数需要与cycleType一同使用<br/>注：最长订购周期为60个月（5年）；cycleType与cycleCount一起填写
     */

    private Integer cycleCount;


    /**
     * clientToken
     * require: true
     * description: 客户端存根，用于保证订单幂等性。要求单个云平台账户内唯一，使用同一个ClientToken值，其他请求参数相同时，则代表为同一个请求。保留时间为24小时
     */

    private String clientToken;





    public String getRegionID() {
        return regionID;
    }

    public V4EbmRenewRequest setRegionID(String regionID) {
        this.regionID = regionID;
        return this;
    }



    public String getAzName() {
        return azName;
    }

    public V4EbmRenewRequest setAzName(String azName) {
        this.azName = azName;
        return this;
    }



    public String getInstanceUUID() {
        return instanceUUID;
    }

    public V4EbmRenewRequest setInstanceUUID(String instanceUUID) {
        this.instanceUUID = instanceUUID;
        return this;
    }



    public Float getPayVoucherPrice() {
        return payVoucherPrice;
    }

    public V4EbmRenewRequest setPayVoucherPrice(Float payVoucherPrice) {
        this.payVoucherPrice = payVoucherPrice;
        return this;
    }



    public String getCycleType() {
        return cycleType;
    }

    public V4EbmRenewRequest setCycleType(String cycleType) {
        this.cycleType = cycleType;
        return this;
    }



    public Integer getCycleCount() {
        return cycleCount;
    }

    public V4EbmRenewRequest setCycleCount(Integer cycleCount) {
        this.cycleCount = cycleCount;
        return this;
    }



    public String getClientToken() {
        return clientToken;
    }

    public V4EbmRenewRequest setClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }


}