
package com.ctyun.openapisdk.request;
import com.ctyun.openapisdk.core.models.CtyunOpenAPIRequest;
import java.util.*;

/**
 * V4EbmListInstance请求类
 * 此文件由天翼云SDK工具自动生成,请勿修改
 */
public class V4EbmListInstanceRequest extends CtyunOpenAPIRequest {

    /**
     * regionID
     * require: true
     * description: 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10026730/10028695">地域和可用区</a>来了解资源池<br/>您可以调用<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81">资源池列表查询</a>获取最新的天翼云资源池列表
     */

    private String regionID;


    /**
     * azName
     * require: true
     * description: 可用区名称，您可以查看地域和可用区来了解可用区<br/>您可以调用<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5855&data=87">资源池可用区查询</a><br/>注：查询结果中zoneList内返回存在可用区名称(即多可用区，本字段填写实际可用区名称)，若查询结果中zoneList为空（即为单可用区，本字段填写default）
     */

    private String azName;


    /**
     * resourceID
     * require: false
     * description: 物理机资源ID
     */

    private String resourceID;


    /**
     * ip
     * require: false
     * description: 弹性ip，公网IP地址
     */

    private String ip;


    /**
     * instanceName
     * require: false
     * description: 实例名称
     */

    private String instanceName;


    /**
     * vpcID
     * require: false
     * description: 虚拟私有云ID，您可以查看<a href="https://www.ctyun.cn/document/10026755/10028310">产品定义-虚拟私有云</a>来了解虚拟私有云<br />&#32;<a  href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&api=4814&data=94">查询VPC列表</a><br /><a  href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&api=4811&data=94">创建VPC</a><br />注：在多可用区类型资源池下，vpcID通常为“vpc-”开头，非多可用区类型资源池vpcID为uuid格式
     */

    private String vpcID;


    /**
     * subnetID
     * require: false
     * description: 子网UUID，您可以查看<a href="https://www.ctyun.cn/document/10026755/10098380">基本概念</a>来查找子网的相关定义<br />&#32;<a href="https://www.ctyun.cn/document/10026755/10040797">查询子网列表</a><br /><a href="https://www.ctyun.cn/document/10026755/10040804">创建子网</a><br />注：在多可用区类型资源池下，subnetID通常以“subnet-”开头；非多可用区类型资源池subnetID为uuid格式
     */

    private String subnetID;


    /**
     * deviceType
     * require: false
     * description: 物理机套餐类型<br /><a href="https://www.ctyun.cn/document/10027724/10040107">查询资源池内物理机套餐</a><br /><a href="https://www.ctyun.cn/document/10027724/10040124">查询指定物理机的套餐信息</a>
     */

    private String deviceType;


    /**
     * deviceUUIDList
     * require: false
     * description: 设备uuid 用,分隔，您可以调用<a href="https://www.ctyun.cn/document/10027724/10040100">查询单台物理机</a>和<a href="https://www.ctyun.cn/document/10027724/10040106">批量查询物理机</a>获取设备uuid
     */

    private String deviceUUIDList;


    /**
     * queryContent
     * require: false
     * description: 对instanceName，内网IP，displayName这些字段模糊查询
     */

    private String queryContent;


    /**
     * instanceUUIDList
     * require: false
     * description: 多个实例UUID用,分隔，您可以调用<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=9715&data=87&isNormal=1">根据订单号查询uuid</a>获取实例UUID
     */

    private String instanceUUIDList;


    /**
     * instanceUUID
     * require: false
     * description: 单个实例UUID，您可以调用<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=9715&data=87&isNormal=1">根据订单号查询uuid</a>获取实例UUID
     */

    private String instanceUUID;


    /**
     * status
     * require: false
     * description: 实例状态，取值范围：CREATING(创建中)，STARTING(开机中)，RUNNING(运行中)，STOPPING(关机中)，RESTARTING(重启中)，ERROR(故障中)，REINSTALLING(重装系统中)，RESETTING_PASSWORD(重置密码中)，ADDING_NETWORK(添加网卡中)，DELETING_NETWORK(删除网卡中),ATTACH_VOLUME(绑定云盘中)，DETACH_VOLUME(解绑云盘中)<br>注：该参数大小写不敏感（如CREATING可填写为creating）
     */

    private String status;


    /**
     * sort
     * require: false
     * description: 排序类型。取值范围：[expire_time]。expire_time表示按到期时间排序，默认为降序排序
     */

    private String sort;


    /**
     * asc
     * require: false
     * description: 排序参数。true表示升序，false表示降序。当未指定排序类型 sort 时，此参数无效
     */

    private Boolean asc;


    /**
     * vipID
     * require: false
     * description: vipID
     */

    private String vipID;


    /**
     * volumeUUID
     * require: false
     * description: 云硬盘UUID
     */

    private String volumeUUID;


    /**
     * pageNo
     * require: false
     * description: 页码，默认从1开始
     */

    private Integer pageNo;


    /**
     * pageSize
     * require: false
     * description: 每页记录数目，取值范围:[1~10000]，默认值:10，单页最大记录不超过10000
     */

    private Integer pageSize;





    public String getRegionID() {
        return regionID;
    }

    public V4EbmListInstanceRequest setRegionID(String regionID) {
        this.regionID = regionID;
        return this;
    }



    public String getAzName() {
        return azName;
    }

    public V4EbmListInstanceRequest setAzName(String azName) {
        this.azName = azName;
        return this;
    }



    public String getResourceID() {
        return resourceID;
    }

    public V4EbmListInstanceRequest setResourceID(String resourceID) {
        this.resourceID = resourceID;
        return this;
    }



    public String getIp() {
        return ip;
    }

    public V4EbmListInstanceRequest setIp(String ip) {
        this.ip = ip;
        return this;
    }



    public String getInstanceName() {
        return instanceName;
    }

    public V4EbmListInstanceRequest setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }



    public String getVpcID() {
        return vpcID;
    }

    public V4EbmListInstanceRequest setVpcID(String vpcID) {
        this.vpcID = vpcID;
        return this;
    }



    public String getSubnetID() {
        return subnetID;
    }

    public V4EbmListInstanceRequest setSubnetID(String subnetID) {
        this.subnetID = subnetID;
        return this;
    }



    public String getDeviceType() {
        return deviceType;
    }

    public V4EbmListInstanceRequest setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }



    public String getDeviceUUIDList() {
        return deviceUUIDList;
    }

    public V4EbmListInstanceRequest setDeviceUUIDList(String deviceUUIDList) {
        this.deviceUUIDList = deviceUUIDList;
        return this;
    }



    public String getQueryContent() {
        return queryContent;
    }

    public V4EbmListInstanceRequest setQueryContent(String queryContent) {
        this.queryContent = queryContent;
        return this;
    }



    public String getInstanceUUIDList() {
        return instanceUUIDList;
    }

    public V4EbmListInstanceRequest setInstanceUUIDList(String instanceUUIDList) {
        this.instanceUUIDList = instanceUUIDList;
        return this;
    }



    public String getInstanceUUID() {
        return instanceUUID;
    }

    public V4EbmListInstanceRequest setInstanceUUID(String instanceUUID) {
        this.instanceUUID = instanceUUID;
        return this;
    }



    public String getStatus() {
        return status;
    }

    public V4EbmListInstanceRequest setStatus(String status) {
        this.status = status;
        return this;
    }



    public String getSort() {
        return sort;
    }

    public V4EbmListInstanceRequest setSort(String sort) {
        this.sort = sort;
        return this;
    }



    public Boolean getAsc() {
        return asc;
    }

    public V4EbmListInstanceRequest setAsc(Boolean asc) {
        this.asc = asc;
        return this;
    }



    public String getVipID() {
        return vipID;
    }

    public V4EbmListInstanceRequest setVipID(String vipID) {
        this.vipID = vipID;
        return this;
    }



    public String getVolumeUUID() {
        return volumeUUID;
    }

    public V4EbmListInstanceRequest setVolumeUUID(String volumeUUID) {
        this.volumeUUID = volumeUUID;
        return this;
    }



    public Integer getPageNo() {
        return pageNo;
    }

    public V4EbmListInstanceRequest setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
        return this;
    }



    public Integer getPageSize() {
        return pageSize;
    }

    public V4EbmListInstanceRequest setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }


}