
package com.ctyun.openapisdk.request;
import com.ctyun.openapisdk.core.models.CtyunOpenAPIRequest;
import java.util.*;

/**
 * V4EbmCreateInstance请求类
 * 此文件由天翼云SDK工具自动生成,请勿修改
 */
public class V4EbmCreateInstanceRequest extends CtyunOpenAPIRequest {

    /**
     * regionID
     * require: true
     * description: 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10026730/10028695">地域和可用区</a>来了解资源池<br/>您可以调用<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81">资源池列表查询</a>获取最新的天翼云资源池列表
     */

    private String regionID;


    /**
     * azName
     * require: true
     * description: 可用区名称，您可以查看地域和可用区来了解可用区<br/>您可以调用<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5855&data=87">资源池可用区查询</a><br/>注：查询结果中zoneList内返回存在可用区名称(即多可用区，本字段填写实际可用区名称)，若查询结果中zoneList为空（即为单可用区，本字段填写default）
     */

    private String azName;


    /**
     * deviceType
     * require: true
     * description: 物理机套餐类型<br/><a href="https://www.ctyun.cn/document/10027724/10040107">查询资源池内物理机套餐</a><br /><a href="https://www.ctyun.cn/document/10027724/10040124">查询指定物理机的套餐信息</a>
     */

    private String deviceType;


    /**
     * instanceName
     * require: true
     * description: 物理机名称，长度为2-31位；<br/>支持模式串{R:x}，表示生成数字[x,x+n-1]，其中n表示购买实例的数量，1 ≤ x ≤ 9799且x只能为整数。<br/>例子：填写server{R:3}pm，购买1台时，实例主机名为server0003pm；购买2台时，实例主机名分别为server0003pm，server0004pm)；除使用模式串外，不支持冒号“:”以及大括号“{}”两类字符单独存在或其它组合方式
     */

    private String instanceName;


    /**
     * hostname
     * require: true
     * description: hostname，linux系统2到63位长度；windows系统2-15位长度；<br/>允许使用大小写字母、数字、连字符'-'，必须以字母开头（大小写均可），不能连续使用'-'，'-'不能用于结尾，不能仅使用数字；<br/>支持模式串{R:x}，表示生成数字[x,x+n-1]，其中n表示购买实例的数量，1 ≤ x ≤ 9799且x只能为整数。<br/>例子：填写server{R:3}pm，购买1台时，实例主机名为server0003pm；购买2台时，实例主机名分别为server0003pm，server0004pm )
     */

    private String hostname;


    /**
     * imageUUID
     * require: true
     * description: 物理机镜像UUID<br /><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=16&api=4577&data=97">查询物理机镜像</a>
     */

    private String imageUUID;


    /**
     * password
     * require: false
     * description: 用户密码，满足以下规则：<br/>长度在8～30个字符；<br/>必须包含大小写字母和（至少一个数字或者特殊字符）；<br/>特殊符号可选：()`~!@#$%&*_-+=｜{}[]:;'<>,.?/，未传入有效的keyName时必须传入password
     */

    private String password;


    /**
     * systemVolumeRaidUUID
     * require: false
     * description: 本地系统盘raid类型，如果有本地系统盘则必填,没有本地系统盘时此参数无效<br/><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=16&api=4576&data=97">查询物理机套餐支持的raid类型</a>
     */

    private String systemVolumeRaidUUID;


    /**
     * dataVolumeRaidUUID
     * require: false
     * description: 本地数据盘raid类型，如果有本地数据盘则必填.没有本地数据盘时此参数无效<br/><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=16&api=4576&data=97">查询物理机套餐支持的raid类型</a>
     */

    private String dataVolumeRaidUUID;


    /**
     * vpcID
     * require: true
     * description: 主网卡虚拟私有云ID，您可以查看<a href="https://www.ctyun.cn/document/10026755/10028310">产品定义-虚拟私有云</a>来了解虚拟私有云<br />&#32;<a  href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&api=4814&data=94">查询VPC列表</a><br /><a  href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&api=4811&data=94">创建VPC</a><br />注：在多可用区类型资源池下，vpcID通常为“vpc-”开头，非多可用区类型资源池vpcID为uuid格式
     */

    private String vpcID;


    /**
     * extIP
     * require: true
     * description: 是否使用弹性公网IP ，取值范围:[1=自动分配,0=不使用,2=使用已有]
     */

    private String extIP;


    /**
     * projectID
     * require: false
     * description: 企业项目ID，企业项目管理服务提供统一的云资源按企业项目管理，以及企业项目内的资源管理，成员管理。您可以通过查看<a href="https://www.ctyun.cn/document/10017248/10017961">创建企业项目</a>了解如何创建企业项目<br />注：默认值为"0"
     */

    private String projectID;


    /**
     * ipType
     * require: false
     * description: 弹性IP版本 ，取值范围:[ipv4=v4地址,ipv6=v6地址]，默认值:ipv4
     */

    private String ipType;


    /**
     * bandWidth
     * require: false
     * description: 带宽 ，单位为Mbit/s，取值范围:[1~2000]，默认值:100
     */

    private Integer bandWidth;


    /**
     * publicIP
     * require: false
     * description: 弹性公网IP的ID，您可以查看<a href="https://www.ctyun.cn/document/10026753/10026909">产品定义-弹性IP</a>来了解弹性公网IP <br /><a href="https://www.ctyun.cn/document/10026753/10040758">查询指定地域已创建的弹性 IP</a><br />&#32;<a href="https://www.ctyun.cn/document/10026753/10040759">创建弹性IP</a>
     */

    private String publicIP;


    /**
     * securityGroupID
     * require: false
     * description: 安全组ID，以逗号,分隔，单次最多允许传入10个安全组ID；套餐中smartNicExist属性为true可支持安全组。创建弹性裸金属必须传入安全组ID，标准裸金属不支持传入安全组ID。您可以查看<a href="https://www.ctyun.cn/document/10026755/10028520">安全组概述</a>了解安全组相关信息 <br /><a href="https://www.ctyun.cn/document/10026755/10040907">查询用户安全组列表</a><br /><a href="https://www.ctyun.cn/document/10026755/10040938">创建安全组</a>&#32;<br /><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=16&api=4574&data=97">查询物理机套餐</a><br /><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=16&api=5117&data=97">物理机查询对应套餐信息</a>
     */

    private String securityGroupID;


    /**
     * diskList
     * require: false
     * description: 云盘信息列表，同一台实例下最多可挂载1块系统盘,8块数据盘。套餐中supportCloud为true表示支持云盘，cloudBoot标识支持云盘系统盘,若不支持则无需填写。<br />您可以通过<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=16&api=4574&data=97">查询资源池内物理机套餐</a>和<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=16&api=5117&data=97">查询指定物理机的套餐信息</a>了解当前物理机是否支持云盘<br/ >您可以调用<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=35&api=7338&data=48">查询云硬盘列表</a>获取云硬盘信息
     */

    private List<V4EbmCreateInstanceDiskList> diskList;


    /**
     * networkCardList
     * require: true
     * description: 网卡信息列表,默认支持1张主网卡，用户可根据需求申请扩大配额。目前可为弹性裸金属配置1张主网卡以及最多8张扩展网卡。标准裸金属最多支持双网卡，1张主网卡以及最多1张扩展网卡。
     */

    private List<V4EbmCreateInstanceNetworkCardList> networkCardList;


    /**
     * userData
     * require: false
     * description: 用户自定义数据,需要以Base64方式编码,Base64编码后的长度限制为1-16384字符
     */

    private String userData;


    /**
     * keyName
     * require: false
     * description: 密钥对名词，密钥对名称。满足以下规则：只能由数字、字母、-组成，不能以数字和-开头、以-结尾，且长度为2-63字符<br/><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8344&data=87&isNormal=1&vid=81">创建一对SSH密钥对</a>
     */

    private String keyName;


    /**
     * labelList
     * require: false
     * description: 标签信息列表，注：单台物理机最多可绑定10个标签；创建完成后，物理机变为运行状态，此时标签仍可能未绑定，需等待一段时间（0-10分钟）
     */

    private List<V4EbmCreateInstanceLabelList> labelList;


    /**
     * payVoucherPrice
     * require: false
     * description: 代金券，满足以下规则：两位小数，不足两位自动补0，超过两位小数部分无效；不可为负数；字段为0时表示不使用代金券
     */

    private Float payVoucherPrice;


    /**
     * autoRenewStatus
     * require: false
     * description: 是否自动续订，默认非自动续订。取值范围：<br/>0（不续费），<br/>1（自动续费），<br/>注：按月购买，自动续订周期为1个月；按年购买，自动续订周期为1年
     */

    private Integer autoRenewStatus;


    /**
     * instanceChargeType
     * require: false
     * description: 实例计费类型，默认为ORDER_ON_CYCLE（包年包月）<br/>&#32;ORDER_ON_CYCLE:包年包月<br/>&#32;ORDER_ON_DEMAND:按量付费
     */

    private String instanceChargeType;


    /**
     * cycleCount
     * require: false
     * description: 订购时长，该参数需要与cycleType一同使用<br/>注：最长订购周期为60个月（5年）；cycleType与cycleCount一起填写；按量付费（即instanceChargeType为ORDER_ON_DEMAND）时，无需填写该参数（填写无效）
     */

    private Integer cycleCount;


    /**
     * cycleType
     * require: false
     * description: 订购周期类型 ，取值范围:[MONTH=按月,YEAR=按年]<br/>注：cycleType与cycleCount一起填写；按量付费（即instanceChargeType为ORDER_ON_DEMAND）时，无需填写该参数（填写无效）
     */

    private String cycleType;


    /**
     * orderCount
     * require: true
     * description: 购买数量
     */

    private Integer orderCount;


    /**
     * clientToken
     * require: true
     * description: 客户端存根，用于保证订单幂等性。要求单个云平台账户内唯一，使用同一个ClientToken值，其他请求参数相同时，则代表为同一个请求。保留时间为24小时
     */

    private String clientToken;


    /**
     * description
     * require: false
     * description: 物理机描述，限制长度为0-255个字符
     */

    private String description;





    public String getRegionID() {
        return regionID;
    }

    public V4EbmCreateInstanceRequest setRegionID(String regionID) {
        this.regionID = regionID;
        return this;
    }



    public String getAzName() {
        return azName;
    }

    public V4EbmCreateInstanceRequest setAzName(String azName) {
        this.azName = azName;
        return this;
    }



    public String getDeviceType() {
        return deviceType;
    }

    public V4EbmCreateInstanceRequest setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }



    public String getInstanceName() {
        return instanceName;
    }

    public V4EbmCreateInstanceRequest setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }



    public String getHostname() {
        return hostname;
    }

    public V4EbmCreateInstanceRequest setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }



    public String getImageUUID() {
        return imageUUID;
    }

    public V4EbmCreateInstanceRequest setImageUUID(String imageUUID) {
        this.imageUUID = imageUUID;
        return this;
    }



    public String getPassword() {
        return password;
    }

    public V4EbmCreateInstanceRequest setPassword(String password) {
        this.password = password;
        return this;
    }



    public String getSystemVolumeRaidUUID() {
        return systemVolumeRaidUUID;
    }

    public V4EbmCreateInstanceRequest setSystemVolumeRaidUUID(String systemVolumeRaidUUID) {
        this.systemVolumeRaidUUID = systemVolumeRaidUUID;
        return this;
    }



    public String getDataVolumeRaidUUID() {
        return dataVolumeRaidUUID;
    }

    public V4EbmCreateInstanceRequest setDataVolumeRaidUUID(String dataVolumeRaidUUID) {
        this.dataVolumeRaidUUID = dataVolumeRaidUUID;
        return this;
    }



    public String getVpcID() {
        return vpcID;
    }

    public V4EbmCreateInstanceRequest setVpcID(String vpcID) {
        this.vpcID = vpcID;
        return this;
    }



    public String getExtIP() {
        return extIP;
    }

    public V4EbmCreateInstanceRequest setExtIP(String extIP) {
        this.extIP = extIP;
        return this;
    }



    public String getProjectID() {
        return projectID;
    }

    public V4EbmCreateInstanceRequest setProjectID(String projectID) {
        this.projectID = projectID;
        return this;
    }



    public String getIpType() {
        return ipType;
    }

    public V4EbmCreateInstanceRequest setIpType(String ipType) {
        this.ipType = ipType;
        return this;
    }



    public Integer getBandWidth() {
        return bandWidth;
    }

    public V4EbmCreateInstanceRequest setBandWidth(Integer bandWidth) {
        this.bandWidth = bandWidth;
        return this;
    }



    public String getPublicIP() {
        return publicIP;
    }

    public V4EbmCreateInstanceRequest setPublicIP(String publicIP) {
        this.publicIP = publicIP;
        return this;
    }



    public String getSecurityGroupID() {
        return securityGroupID;
    }

    public V4EbmCreateInstanceRequest setSecurityGroupID(String securityGroupID) {
        this.securityGroupID = securityGroupID;
        return this;
    }



    public List<V4EbmCreateInstanceDiskList> getDiskList() {
        return diskList;
    }

    public V4EbmCreateInstanceRequest setDiskList(List<V4EbmCreateInstanceDiskList> diskList) {
        this.diskList = diskList;
        return this;
    }



    public List<V4EbmCreateInstanceNetworkCardList> getNetworkCardList() {
        return networkCardList;
    }

    public V4EbmCreateInstanceRequest setNetworkCardList(List<V4EbmCreateInstanceNetworkCardList> networkCardList) {
        this.networkCardList = networkCardList;
        return this;
    }



    public String getUserData() {
        return userData;
    }

    public V4EbmCreateInstanceRequest setUserData(String userData) {
        this.userData = userData;
        return this;
    }



    public String getKeyName() {
        return keyName;
    }

    public V4EbmCreateInstanceRequest setKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }



    public List<V4EbmCreateInstanceLabelList> getLabelList() {
        return labelList;
    }

    public V4EbmCreateInstanceRequest setLabelList(List<V4EbmCreateInstanceLabelList> labelList) {
        this.labelList = labelList;
        return this;
    }



    public Float getPayVoucherPrice() {
        return payVoucherPrice;
    }

    public V4EbmCreateInstanceRequest setPayVoucherPrice(Float payVoucherPrice) {
        this.payVoucherPrice = payVoucherPrice;
        return this;
    }



    public Integer getAutoRenewStatus() {
        return autoRenewStatus;
    }

    public V4EbmCreateInstanceRequest setAutoRenewStatus(Integer autoRenewStatus) {
        this.autoRenewStatus = autoRenewStatus;
        return this;
    }



    public String getInstanceChargeType() {
        return instanceChargeType;
    }

    public V4EbmCreateInstanceRequest setInstanceChargeType(String instanceChargeType) {
        this.instanceChargeType = instanceChargeType;
        return this;
    }



    public Integer getCycleCount() {
        return cycleCount;
    }

    public V4EbmCreateInstanceRequest setCycleCount(Integer cycleCount) {
        this.cycleCount = cycleCount;
        return this;
    }



    public String getCycleType() {
        return cycleType;
    }

    public V4EbmCreateInstanceRequest setCycleType(String cycleType) {
        this.cycleType = cycleType;
        return this;
    }



    public Integer getOrderCount() {
        return orderCount;
    }

    public V4EbmCreateInstanceRequest setOrderCount(Integer orderCount) {
        this.orderCount = orderCount;
        return this;
    }



    public String getClientToken() {
        return clientToken;
    }

    public V4EbmCreateInstanceRequest setClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }



    public String getDescription() {
        return description;
    }

    public V4EbmCreateInstanceRequest setDescription(String description) {
        this.description = description;
        return this;
    }


}