/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.sdk;

import cn.ctyun.sdk.HttpHook;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSource;

public class HttpHooks {

    public static class PrintLogHttpHook
    implements HttpHook {
        @Override
        public void beforeRequest(Request request) {
            System.out.println("Request url: " + request.url() + "\n");
            System.out.println("Request headers: " + request.headers() + "\n");
            if (request.body() != null) {
                try {
                    Buffer buffer = new Buffer();
                    request.body().writeTo(buffer);
                    String bodyString = buffer.readString(StandardCharsets.UTF_8);
                    System.out.println("Request body: " + bodyString + "\n");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void afterResponse(Response response) {
            System.out.println("Response headers: " + response.headers() + "\n");
            if (response.body() != null) {
                try {
                    BufferedSource source2 = response.body().source().peek();
                    String responseBody = source2.readUtf8();
                    System.out.println("Response body: " + responseBody + "\n");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

