/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class Dcs2ListTasksApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2ListTasksApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("dcs2", "POST", "/v2/taskCenter/listTasks", "application/json");
    }

    public ListTasksResponse send(Credential credential, ListTasksRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListTasksResponse.class);
    }

    public static class ListTasksReturnObjRowsResponse {
        @JsonProperty(value="taskId")
        private String taskId;
        @JsonProperty(value="prodInstId")
        private String prodInstId;
        @JsonProperty(value="taskType")
        private Integer taskType;
        @JsonProperty(value="taskTypeDesc")
        private String taskTypeDesc;
        @JsonProperty(value="status")
        private Integer status;
        @JsonProperty(value="startTime")
        private Long startTime;
        @JsonProperty(value="endTime")
        private Long endTime;
        @JsonProperty(value="detail")
        private List<String> detail;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Integer getTaskType() {
            return this.taskType;
        }

        public void setTaskType(Integer taskType) {
            this.taskType = taskType;
        }

        public String getTaskTypeDesc() {
            return this.taskTypeDesc;
        }

        public void setTaskTypeDesc(String taskTypeDesc) {
            this.taskTypeDesc = taskTypeDesc;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public List<String> getDetail() {
            return this.detail;
        }

        public void setDetail(List<String> detail) {
            this.detail = detail;
        }
    }

    public static class ListTasksReturnObjResponse {
        @JsonProperty(value="total")
        private Integer total;
        @JsonProperty(value="rows")
        private List<ListTasksReturnObjRowsResponse> rows;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<ListTasksReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<ListTasksReturnObjRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class ListTasksResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="returnObj")
        private ListTasksReturnObjResponse returnObj;
        @JsonProperty(value="requestId")
        private String requestId;
        @JsonProperty(value="code")
        private String code;
        @JsonProperty(value="error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ListTasksReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListTasksReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ListTasksConditionRequest {
        @JsonProperty(value="taskTypeStr")
        private String taskTypeStr;
        @JsonProperty(value="status")
        private Integer status;
        @JsonProperty(value="prodInstId")
        private String prodInstId;
        @JsonProperty(value="startTimeDesc")
        private Integer startTimeDesc;

        public String getTaskTypeStr() {
            return this.taskTypeStr;
        }

        public void setTaskTypeStr(String taskTypeStr) {
            this.taskTypeStr = taskTypeStr;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Integer getStartTimeDesc() {
            return this.startTimeDesc;
        }

        public void setStartTimeDesc(Integer startTimeDesc) {
            this.startTimeDesc = startTimeDesc;
        }
    }

    public static class ListTasksRequest {
        @JsonProperty(value="regionId")
        private String regionId;
        @JsonProperty(value="startTime")
        private String startTime;
        @JsonProperty(value="endTime")
        private String endTime;
        @JsonProperty(value="pageIndex")
        private Integer pageIndex;
        @JsonProperty(value="pageSize")
        private Integer pageSize;
        @JsonProperty(value="condition")
        private ListTasksConditionRequest condition;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public Integer getPageIndex() {
            return this.pageIndex;
        }

        public void setPageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public ListTasksConditionRequest getCondition() {
            return this.condition;
        }

        public void setCondition(ListTasksConditionRequest condition) {
            this.condition = condition;
        }
    }
}

