/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Dcs2CreateTransferTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2CreateTransferTaskApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("dcs2", "POST", "/v2/transfer/createTransferTask", "application/json");
    }

    public CreateTransferTaskResponse send(Credential credential, CreateTransferTaskRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateTransferTaskResponse.class);
    }

    public static class CreateTransferTaskReturnObjResponse {
    }

    public static class CreateTransferTaskResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="returnObj")
        private CreateTransferTaskReturnObjResponse returnObj;
        @JsonProperty(value="requestId")
        private String requestId;
        @JsonProperty(value="code")
        private String code;
        @JsonProperty(value="error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CreateTransferTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateTransferTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CreateTransferTaskTargetDbInfoRequest {
        @JsonProperty(value="spuInstId")
        private String spuInstId;
        @JsonProperty(value="ipAddr")
        private String ipAddr;
        @JsonProperty(value="originalCluster")
        private Boolean originalCluster;
        @JsonProperty(value="accountName")
        private String accountName;
        @JsonProperty(value="password")
        private String password;

        public String getSpuInstId() {
            return this.spuInstId;
        }

        public void setSpuInstId(String spuInstId) {
            this.spuInstId = spuInstId;
        }

        public String getIpAddr() {
            return this.ipAddr;
        }

        public void setIpAddr(String ipAddr) {
            this.ipAddr = ipAddr;
        }

        public Boolean getOriginalCluster() {
            return this.originalCluster;
        }

        public void setOriginalCluster(Boolean originalCluster) {
            this.originalCluster = originalCluster;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class CreateTransferTaskSourceDbInfoRequest {
        @JsonProperty(value="spuInstId")
        private String spuInstId;
        @JsonProperty(value="ipAddr")
        private String ipAddr;
        @JsonProperty(value="originalCluster")
        private Boolean originalCluster;
        @JsonProperty(value="accountName")
        private String accountName;
        @JsonProperty(value="password")
        private String password;

        public String getSpuInstId() {
            return this.spuInstId;
        }

        public void setSpuInstId(String spuInstId) {
            this.spuInstId = spuInstId;
        }

        public String getIpAddr() {
            return this.ipAddr;
        }

        public void setIpAddr(String ipAddr) {
            this.ipAddr = ipAddr;
        }

        public Boolean getOriginalCluster() {
            return this.originalCluster;
        }

        public void setOriginalCluster(Boolean originalCluster) {
            this.originalCluster = originalCluster;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class CreateTransferTaskRequest {
        @JsonProperty(value="regionId")
        private String regionId;
        @JsonProperty(value="sourceDbInfo")
        private CreateTransferTaskSourceDbInfoRequest sourceDbInfo;
        @JsonProperty(value="targetDbInfo")
        private CreateTransferTaskTargetDbInfoRequest targetDbInfo;
        @JsonProperty(value="syncMode")
        private Integer syncMode;
        @JsonProperty(value="conflictMode")
        private Integer conflictMode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public CreateTransferTaskSourceDbInfoRequest getSourceDbInfo() {
            return this.sourceDbInfo;
        }

        public void setSourceDbInfo(CreateTransferTaskSourceDbInfoRequest sourceDbInfo) {
            this.sourceDbInfo = sourceDbInfo;
        }

        public CreateTransferTaskTargetDbInfoRequest getTargetDbInfo() {
            return this.targetDbInfo;
        }

        public void setTargetDbInfo(CreateTransferTaskTargetDbInfoRequest targetDbInfo) {
            this.targetDbInfo = targetDbInfo;
        }

        public Integer getSyncMode() {
            return this.syncMode;
        }

        public void setSyncMode(Integer syncMode) {
            this.syncMode = syncMode;
        }

        public Integer getConflictMode() {
            return this.conflictMode;
        }

        public void setConflictMode(Integer conflictMode) {
            this.conflictMode = conflictMode;
        }
    }
}

