/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Dcs2CreateInstanceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2CreateInstanceApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("dcs2", "POST", "/v2/lifeCycleServant/createInstance", "application/json");
    }

    public CreateInstanceResponse send(Credential credential, CreateInstanceRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.projectID != null) {
            ctReq.addHeader("projectID", request.projectID);
            request.projectID = null;
        }
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateInstanceResponse.class);
    }

    public static class CreateInstanceReturnObjResponse {
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="submitted")
        private Boolean submitted;
        @JsonProperty(value="newOrderId")
        private String newOrderId;
        @JsonProperty(value="newOrderNo")
        private String newOrderNo;
        @JsonProperty(value="totalPrice")
        private Double totalPrice;

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Boolean getSubmitted() {
            return this.submitted;
        }

        public void setSubmitted(Boolean submitted) {
            this.submitted = submitted;
        }

        public String getNewOrderId() {
            return this.newOrderId;
        }

        public void setNewOrderId(String newOrderId) {
            this.newOrderId = newOrderId;
        }

        public String getNewOrderNo() {
            return this.newOrderNo;
        }

        public void setNewOrderNo(String newOrderNo) {
            this.newOrderNo = newOrderNo;
        }

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }
    }

    public static class CreateInstanceResponse {
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="returnObj")
        private CreateInstanceReturnObjResponse returnObj;
        @JsonProperty(value="requestId")
        private String requestId;
        @JsonProperty(value="code")
        private String code;
        @JsonProperty(value="error")
        private String error;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public CreateInstanceReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateInstanceReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CreateInstanceRequest {
        @JsonProperty(value="regionId")
        private String regionId;
        @JsonProperty(value="projectID")
        private String projectID;
        @JsonProperty(value="chargeType")
        private String chargeType;
        @JsonProperty(value="period")
        private Integer period;
        @JsonProperty(value="autoPay")
        private Boolean autoPay;
        @JsonProperty(value="size")
        private Integer size;
        @JsonProperty(value="autoRenew")
        private Boolean autoRenew;
        @JsonProperty(value="autoRenewPeriod")
        private String autoRenewPeriod;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="edition")
        private String edition;
        @JsonProperty(value="engineVersion")
        private String engineVersion;
        @JsonProperty(value="zoneName")
        private String zoneName;
        @JsonProperty(value="secondaryZoneName")
        private String secondaryZoneName;
        @JsonProperty(value="hostType")
        private String hostType;
        @JsonProperty(value="shardMemSize")
        private String shardMemSize;
        @JsonProperty(value="shardCount")
        private Integer shardCount;
        @JsonProperty(value="capacity")
        private String capacity;
        @JsonProperty(value="copiesCount")
        private Integer copiesCount;
        @JsonProperty(value="dataDiskType")
        private String dataDiskType;
        @JsonProperty(value="vpcId")
        private String vpcId;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="secgroups")
        private String secgroups;
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonProperty(value="cacheServerPort")
        private Integer cacheServerPort;
        @JsonProperty(value="password")
        private String password;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public String getChargeType() {
            return this.chargeType;
        }

        public void setChargeType(String chargeType) {
            this.chargeType = chargeType;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }

        public Boolean getAutoPay() {
            return this.autoPay;
        }

        public void setAutoPay(Boolean autoPay) {
            this.autoPay = autoPay;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Boolean getAutoRenew() {
            return this.autoRenew;
        }

        public void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public String getAutoRenewPeriod() {
            return this.autoRenewPeriod;
        }

        public void setAutoRenewPeriod(String autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getEdition() {
            return this.edition;
        }

        public void setEdition(String edition) {
            this.edition = edition;
        }

        public String getEngineVersion() {
            return this.engineVersion;
        }

        public void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public String getZoneName() {
            return this.zoneName;
        }

        public void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public String getSecondaryZoneName() {
            return this.secondaryZoneName;
        }

        public void setSecondaryZoneName(String secondaryZoneName) {
            this.secondaryZoneName = secondaryZoneName;
        }

        public String getHostType() {
            return this.hostType;
        }

        public void setHostType(String hostType) {
            this.hostType = hostType;
        }

        public String getShardMemSize() {
            return this.shardMemSize;
        }

        public void setShardMemSize(String shardMemSize) {
            this.shardMemSize = shardMemSize;
        }

        public Integer getShardCount() {
            return this.shardCount;
        }

        public void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        public String getCapacity() {
            return this.capacity;
        }

        public void setCapacity(String capacity) {
            this.capacity = capacity;
        }

        public Integer getCopiesCount() {
            return this.copiesCount;
        }

        public void setCopiesCount(Integer copiesCount) {
            this.copiesCount = copiesCount;
        }

        public String getDataDiskType() {
            return this.dataDiskType;
        }

        public void setDataDiskType(String dataDiskType) {
            this.dataDiskType = dataDiskType;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public String getSubnetId() {
            return this.subnetId;
        }

        public void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public String getSecgroups() {
            return this.secgroups;
        }

        public void setSecgroups(String secgroups) {
            this.secgroups = secgroups;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public Integer getCacheServerPort() {
            return this.cacheServerPort;
        }

        public void setCacheServerPort(Integer cacheServerPort) {
            this.cacheServerPort = cacheServerPort;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

