/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class Dcs2AsyncExportInstancesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2AsyncExportInstancesApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("dcs2", "POST", "/v2/instanceManageMgrServant/asyncExportInstances", "application/json");
    }

    public AsyncExportInstancesResponse send(Credential credential, AsyncExportInstancesRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(AsyncExportInstancesResponse.class);
    }

    public static class AsyncExportInstancesReturnObjResponse {
        @JsonProperty(value="taskId")
        private String taskId;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }

    public static class AsyncExportInstancesResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="returnObj")
        private AsyncExportInstancesReturnObjResponse returnObj;
        @JsonProperty(value="requestId")
        private String requestId;
        @JsonProperty(value="code")
        private String code;
        @JsonProperty(value="error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public AsyncExportInstancesReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(AsyncExportInstancesReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class AsyncExportInstancesRequest {
        @JsonProperty(value="regionId")
        private String regionId;
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonProperty(value="capacity")
        private String capacity;
        @JsonProperty(value="prodInstId")
        private String prodInstId;
        @JsonProperty(value="vip")
        private String vip;
        @JsonProperty(value="status")
        private Integer status;
        @JsonProperty(value="engineVersion")
        private String engineVersion;
        @JsonProperty(value="payType")
        private Integer payType;
        @JsonProperty(value="cpuArchType")
        private String cpuArchType;
        @JsonProperty(value="labelIds")
        private List<String> labelIds;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getCapacity() {
            return this.capacity;
        }

        public void setCapacity(String capacity) {
            this.capacity = capacity;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getVip() {
            return this.vip;
        }

        public void setVip(String vip) {
            this.vip = vip;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getEngineVersion() {
            return this.engineVersion;
        }

        public void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public Integer getPayType() {
            return this.payType;
        }

        public void setPayType(Integer payType) {
            this.payType = payType;
        }

        public String getCpuArchType() {
            return this.cpuArchType;
        }

        public void setCpuArchType(String cpuArchType) {
            this.cpuArchType = cpuArchType;
        }

        public List<String> getLabelIds() {
            return this.labelIds;
        }

        public void setLabelIds(List<String> labelIds) {
            this.labelIds = labelIds;
        }
    }
}

