package cn.ctyun.sdk;

import okhttp3.Request;
import okhttp3.Response;

import okio.Buffer;
import okio.BufferedSource;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class HttpHooks {

    public static class PrintLogHttpHook implements HttpHook {

        @Override
        public void beforeRequest(Request request) {
            // 打印请求信息
            System.out.println("Request url: " + request.url() + "\n");
            System.out.println("Request headers: " + request.headers() + "\n");
            if (request.body() != null) {
                try {
                    Buffer buffer = new Buffer();
                    request.body().writeTo(buffer);
                    String bodyString = buffer.readString(StandardCharsets.UTF_8);
                    System.out.println("Request body: " + bodyString + "\n");
                } catch (IOException e) {
                }
            }
        }

        @Override
        public void afterResponse(Response response) {
            // 打印响应信息
            System.out.println("Response headers: " + response.headers() + "\n");
            if (response.body() != null) {
                try {
                    BufferedSource source = response.body().source().peek();
                    String responseBody = source.readUtf8();
                    System.out.println("Response body: " + responseBody + "\n");
                } catch (IOException e) {
                }
            }
        }
    }
}
