package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询迁移日志列表。 */
public class Dcs2UploadSyncRunningLogApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2UploadSyncRunningLogApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/transfer/uploadSyncRunningLog",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UploadSyncRunningLogResponse send(
            Credential credential, UploadSyncRunningLogRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UploadSyncRunningLogResponse.class);
    }

    public static class UploadSyncRunningLogRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 任务ID，可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=15103&data=81&isNormal=1&vid=270">查询数据迁移任务列表</a>
         */
        @JsonProperty("taskId")
        private String taskId;

        /** 查询的日志时间（格式：yyyy-MM-dd） */
        @JsonProperty("searchDate")
        private String searchDate;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getSearchDate() {
            return this.searchDate;
        }

        public void setSearchDate(String searchDate) {
            this.searchDate = searchDate;
        }
    }

    public static class UploadSyncRunningLogResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private UploadSyncRunningLogReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UploadSyncRunningLogReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UploadSyncRunningLogReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class UploadSyncRunningLogReturnObjResponse {
        /** 下载地址列表。 */
        @JsonProperty("downloadUrlList")
        private List<String> downloadUrlList;

        public List<String> getDownloadUrlList() {
            return this.downloadUrlList;
        }

        public void setDownloadUrlList(List<String> downloadUrlList) {
            this.downloadUrlList = downloadUrlList;
        }
    }
}
