package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询该租户在当前区域下不同状态的实例数。 */
public class Dcs2StatusNumberApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2StatusNumberApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/instanceManageMgrServant/statusNumber", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public StatusNumberResponse send(Credential credential, StatusNumberRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.includeFailure != null) {
            ctReq.addParam("includeFailure", request.includeFailure);
            request.includeFailure = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(StatusNumberResponse.class);
    }

    public static class StatusNumberRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 是否返回创建失败的实例数，可选值：
         * <li>true(默认)。
         * <li>false。
         */
        @JsonProperty("includeFailure")
        private String includeFailure;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getIncludeFailure() {
            return this.includeFailure;
        }

        public void setIncludeFailure(String includeFailure) {
            this.includeFailure = includeFailure;
        }
    }

    public static class StatusNumberResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private StatusNumberReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public StatusNumberReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(StatusNumberReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class StatusNumberReturnObjResponse {
        /** 运行中的实例数。 */
        @JsonProperty("runningCount")
        private Integer runningCount;

        /** 创建中的实例数。 */
        @JsonProperty("creatingCount")
        private Integer creatingCount;

        /** 冻结中的实例数。 */
        @JsonProperty("frozenCount")
        private Integer frozenCount;

        /** 变更中的实例数。 */
        @JsonProperty("changingCount")
        private Integer changingCount;

        /** 创建失败的实例数。 */
        @JsonProperty("createFailedCount")
        private Integer createFailedCount;

        /** 重启中的实例数。 */
        @JsonProperty("restartingCount")
        private Integer restartingCount;

        /** 异常的实例数。 */
        @JsonProperty("errorCount")
        private Integer errorCount;

        public Integer getRunningCount() {
            return this.runningCount;
        }

        public void setRunningCount(Integer runningCount) {
            this.runningCount = runningCount;
        }

        public Integer getCreatingCount() {
            return this.creatingCount;
        }

        public void setCreatingCount(Integer creatingCount) {
            this.creatingCount = creatingCount;
        }

        public Integer getFrozenCount() {
            return this.frozenCount;
        }

        public void setFrozenCount(Integer frozenCount) {
            this.frozenCount = frozenCount;
        }

        public Integer getChangingCount() {
            return this.changingCount;
        }

        public void setChangingCount(Integer changingCount) {
            this.changingCount = changingCount;
        }

        public Integer getCreateFailedCount() {
            return this.createFailedCount;
        }

        public void setCreateFailedCount(Integer createFailedCount) {
            this.createFailedCount = createFailedCount;
        }

        public Integer getRestartingCount() {
            return this.restartingCount;
        }

        public void setRestartingCount(Integer restartingCount) {
            this.restartingCount = restartingCount;
        }

        public Integer getErrorCount() {
            return this.errorCount;
        }

        public void setErrorCount(Integer errorCount) {
            this.errorCount = errorCount;
        }
    }
}
