package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询当前租户下处于“运行中”状态的分布式缓存Redis实例的统计信息。 */
public class Dcs2StatisticApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2StatisticApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/instanceManageMgrServant/statistic", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public StatisticResponse send(Credential credential, StatisticRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.includeFailure != null) {
            ctReq.addParam("includeFailure", request.includeFailure);
            request.includeFailure = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(StatisticResponse.class);
    }

    public static class StatisticRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 是否返回创建失败的实例数，可选值：
         * <li>true(默认)。
         * <li>false。
         */
        @JsonProperty("includeFailure")
        private String includeFailure;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getIncludeFailure() {
            return this.includeFailure;
        }

        public void setIncludeFailure(String includeFailure) {
            this.includeFailure = includeFailure;
        }
    }

    public static class StatisticResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private StatisticReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public StatisticReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(StatisticReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class StatisticReturnObjResponse {
        /** 返回数据对象，数据见statistics。 */
        @JsonProperty("statistics")
        private List<StatisticReturnObjStatisticsResponse> statistics;

        public List<StatisticReturnObjStatisticsResponse> getStatistics() {
            return this.statistics;
        }

        public void setStatistics(List<StatisticReturnObjStatisticsResponse> statistics) {
            this.statistics = statistics;
        }
    }

    public static class StatisticReturnObjStatisticsResponse {
        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("instanceId")
        private String instanceId;

        /** 实例网络入流量，单位：kbit/s。 */
        @JsonProperty("inputKbps")
        private String inputKbps;

        /** 实例网络出流量，单位：kbit/s。 */
        @JsonProperty("outputKbps")
        private String outputKbps;

        /** 存储的KEY数量。 */
        @JsonProperty("keys")
        private Integer keys;

        /** 使用中的内存，单位：MB。 */
        @JsonProperty("usedMemory")
        private Integer usedMemory;

        /** 最大的内存，单位：MB。 */
        @JsonProperty("maxMemory")
        private Integer maxMemory;

        /** GET命令调用次数。 */
        @JsonProperty("cmdGetCount")
        private Integer cmdGetCount;

        /** SET命令调用次数。 */
        @JsonProperty("cmdSetCount")
        private Integer cmdSetCount;

        /** 实例进程消耗cpu时间的累计值，单位：秒。 */
        @JsonProperty("usedCpu")
        private String usedCpu;

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getInputKbps() {
            return this.inputKbps;
        }

        public void setInputKbps(String inputKbps) {
            this.inputKbps = inputKbps;
        }

        public String getOutputKbps() {
            return this.outputKbps;
        }

        public void setOutputKbps(String outputKbps) {
            this.outputKbps = outputKbps;
        }

        public Integer getKeys() {
            return this.keys;
        }

        public void setKeys(Integer keys) {
            this.keys = keys;
        }

        public Integer getUsedMemory() {
            return this.usedMemory;
        }

        public void setUsedMemory(Integer usedMemory) {
            this.usedMemory = usedMemory;
        }

        public Integer getMaxMemory() {
            return this.maxMemory;
        }

        public void setMaxMemory(Integer maxMemory) {
            this.maxMemory = maxMemory;
        }

        public Integer getCmdGetCount() {
            return this.cmdGetCount;
        }

        public void setCmdGetCount(Integer cmdGetCount) {
            this.cmdGetCount = cmdGetCount;
        }

        public Integer getCmdSetCount() {
            return this.cmdSetCount;
        }

        public void setCmdSetCount(Integer cmdSetCount) {
            this.cmdSetCount = cmdSetCount;
        }

        public String getUsedCpu() {
            return this.usedCpu;
        }

        public void setUsedCpu(String usedCpu) {
            this.usedCpu = usedCpu;
        }
    }
}
