package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 停止Proxy节点故障注入。 */
public class Dcs2ShutDownProxyFaultInjectApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2ShutDownProxyFaultInjectApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/inject/shutDownProxyFaultInject",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ShutDownProxyFaultInjectResponse send(
            Credential credential, ShutDownProxyFaultInjectRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShutDownProxyFaultInjectResponse.class);
    }

    public static class ShutDownProxyFaultInjectRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口，使用resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID。 */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 故障持续时间(秒), 最小值为60。 */
        @JsonProperty("duration")
        private Integer duration;

        /** 目标故障Redis节点列表。 */
        @JsonProperty("nodes")
        private List<ShutDownProxyFaultInjectNodesRequest> nodes;

        /**
         * 故障动作类型：
         * <li>node-killproxy：停止Proxy节点。
         */
        @JsonProperty("actionCode")
        private String actionCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public void setDuration(Integer duration) {
            this.duration = duration;
        }

        public List<ShutDownProxyFaultInjectNodesRequest> getNodes() {
            return this.nodes;
        }

        public void setNodes(List<ShutDownProxyFaultInjectNodesRequest> nodes) {
            this.nodes = nodes;
        }

        public String getActionCode() {
            return this.actionCode;
        }

        public void setActionCode(String actionCode) {
            this.actionCode = actionCode;
        }
    }

    public static class ShutDownProxyFaultInjectNodesRequest {
        /**
         * 代理节点名称。 可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7741&isNormal=1&vid=270">查询实例的逻辑拓扑</a>
         * 接口，使用AccessNode表proxyName字段。
         */
        @JsonProperty("componentName")
        private String componentName;

        /**
         * 对Proxy的操作。
         * <li>stop：停止Proxy节点。
         */
        @JsonProperty("operation")
        private String operation;

        public String getComponentName() {
            return this.componentName;
        }

        public void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }
    }

    public static class ShutDownProxyFaultInjectResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private ShutDownProxyFaultInjectReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码描述。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ShutDownProxyFaultInjectReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShutDownProxyFaultInjectReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ShutDownProxyFaultInjectReturnObjResponse {
        /** 撤销故障任务ID，使用该任务ID查询撤销故障执行详情。 */
        @JsonProperty("taskId")
        private String taskId;

        /** 演练ID，故障注入与故障恢复一起构成完整的一次故障演练，使用该ID查询故障执行详情与执行撤销故障。 */
        @JsonProperty("experimentId")
        private String experimentId;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getExperimentId() {
            return this.experimentId;
        }

        public void setExperimentId(String experimentId) {
            this.experimentId = experimentId;
        }
    }
}
