package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 为包年包月的分布式缓存Redis实例续费。 */
public class Dcs2RenewInstanceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2RenewInstanceApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/lifeCycleServant/renewInstance",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public RenewInstanceResponse send(Credential credential, RenewInstanceRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(RenewInstanceResponse.class);
    }

    public static class RenewInstanceRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 是否自动支付（仅对包周期实例有效），可选值：
         * <li>true：自动付费。
         * <li>false：手动付费(默认值)。<br>
         *     说明：选择为手动付费时，您需要在控制台的右上角选择我的订单，然后单击左侧导航栏的订单管理 -> 待支付订单，找到目标订单进行支付。
         */
        @JsonProperty("autoPay")
        private Boolean autoPay;

        /** 订购时长(月)，仅当包周期实例需要进行续费，取值范围：1~6,12,24,36。 */
        @JsonProperty("period")
        private Integer period;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Boolean getAutoPay() {
            return this.autoPay;
        }

        public void setAutoPay(Boolean autoPay) {
            this.autoPay = autoPay;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }
    }

    public static class RenewInstanceResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private RenewInstanceReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public RenewInstanceReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(RenewInstanceReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class RenewInstanceReturnObjResponse {
        /** 错误信息。 */
        @JsonProperty("errorMessage")
        private String errorMessage;

        /** 是否提交。 */
        @JsonProperty("submitted")
        private Boolean submitted;

        /** 收费项。 */
        @JsonProperty("orderPlacedEvents")
        private List<RenewInstanceReturnObjOrderPlacedEventsResponse> orderPlacedEvents;

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Boolean getSubmitted() {
            return this.submitted;
        }

        public void setSubmitted(Boolean submitted) {
            this.submitted = submitted;
        }

        public List<RenewInstanceReturnObjOrderPlacedEventsResponse> getOrderPlacedEvents() {
            return this.orderPlacedEvents;
        }

        public void setOrderPlacedEvents(
                List<RenewInstanceReturnObjOrderPlacedEventsResponse> orderPlacedEvents) {
            this.orderPlacedEvents = orderPlacedEvents;
        }
    }

    public static class RenewInstanceReturnObjOrderPlacedEventsResponse {
        /** 错误信息。 */
        @JsonProperty("errorMessage")
        private String errorMessage;

        /** 是否提交。 */
        @JsonProperty("submitted")
        private Boolean submitted;

        /** 订单ID。 */
        @JsonProperty("newOrderId")
        private String newOrderId;

        /** 订单号。 */
        @JsonProperty("newOrderNo")
        private String newOrderNo;

        /** 总价。 */
        @JsonProperty("totalPrice")
        private Double totalPrice;

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Boolean getSubmitted() {
            return this.submitted;
        }

        public void setSubmitted(Boolean submitted) {
            this.submitted = submitted;
        }

        public String getNewOrderId() {
            return this.newOrderId;
        }

        public void setNewOrderId(String newOrderId) {
            this.newOrderId = newOrderId;
        }

        public String getNewOrderNo() {
            return this.newOrderNo;
        }

        public void setNewOrderNo(String newOrderNo) {
            this.newOrderNo = newOrderNo;
        }

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }
    }
}
