package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询租户和用户默认可以创建的实例数和总内存的配额限制。不同的资源池配额可能不同。 */
public class Dcs2QueryQuotaTotalAndUsedApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2QueryQuotaTotalAndUsedApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/quota/queryQuotaTotalAndUsed", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryQuotaTotalAndUsedResponse send(
            Credential credential, QueryQuotaTotalAndUsedRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryQuotaTotalAndUsedResponse.class);
    }

    public static class QueryQuotaTotalAndUsedRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class QueryQuotaTotalAndUsedResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private QueryQuotaTotalAndUsedReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public QueryQuotaTotalAndUsedReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryQuotaTotalAndUsedReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryQuotaTotalAndUsedReturnObjResponse {
        /** 配额列表。 */
        @JsonProperty("quotaCenterDataList")
        private List<QueryQuotaTotalAndUsedReturnObjQuotaCenterDataListResponse>
                quotaCenterDataList;

        public List<QueryQuotaTotalAndUsedReturnObjQuotaCenterDataListResponse>
                getQuotaCenterDataList() {
            return this.quotaCenterDataList;
        }

        public void setQuotaCenterDataList(
                List<QueryQuotaTotalAndUsedReturnObjQuotaCenterDataListResponse>
                        quotaCenterDataList) {
            this.quotaCenterDataList = quotaCenterDataList;
        }
    }

    public static class QueryQuotaTotalAndUsedReturnObjQuotaCenterDataListResponse {
        /** 用户ID。 */
        @JsonProperty("userId")
        private String userId;

        /** 租户ID。 */
        @JsonProperty("tenantId")
        private String tenantId;

        /** 资源池ID。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 配额信息。 */
        @JsonProperty("quotaCenterAccountResourceDataList")
        private List<
                        QueryQuotaTotalAndUsedReturnObjQuotaCenterDataListQuotaCenterAccountResourceDataListResponse>
                quotaCenterAccountResourceDataList;

        /** 配额信息。 */
        @JsonProperty("quotaCenterUserResourceDataList")
        private List<
                        QueryQuotaTotalAndUsedReturnObjQuotaCenterDataListQuotaCenterUserResourceDataListResponse>
                quotaCenterUserResourceDataList;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<
                        QueryQuotaTotalAndUsedReturnObjQuotaCenterDataListQuotaCenterAccountResourceDataListResponse>
                getQuotaCenterAccountResourceDataList() {
            return this.quotaCenterAccountResourceDataList;
        }

        public void setQuotaCenterAccountResourceDataList(
                List<
                                QueryQuotaTotalAndUsedReturnObjQuotaCenterDataListQuotaCenterAccountResourceDataListResponse>
                        quotaCenterAccountResourceDataList) {
            this.quotaCenterAccountResourceDataList = quotaCenterAccountResourceDataList;
        }

        public List<
                        QueryQuotaTotalAndUsedReturnObjQuotaCenterDataListQuotaCenterUserResourceDataListResponse>
                getQuotaCenterUserResourceDataList() {
            return this.quotaCenterUserResourceDataList;
        }

        public void setQuotaCenterUserResourceDataList(
                List<
                                QueryQuotaTotalAndUsedReturnObjQuotaCenterDataListQuotaCenterUserResourceDataListResponse>
                        quotaCenterUserResourceDataList) {
            this.quotaCenterUserResourceDataList = quotaCenterUserResourceDataList;
        }
    }

    public static
    class QueryQuotaTotalAndUsedReturnObjQuotaCenterDataListQuotaCenterAccountResourceDataListResponse {
        /**
         * 配置项编码。
         * <li>dcs2_instanceCount_TQ_PID_202000: 租户缓存实例数量
         * <li>dcs2_busiQuota_TQ_totalMemSize: 租户缓存存储容量
         * <li>dcs2_instanceCount_UQ_PID_202000： 子账号缓存实例数量
         * <li>dcs2_busiQuota_UQ_totalMemSize: 子账号缓存存储容量
         */
        @JsonProperty("quotaId")
        private String quotaId;

        /** 已使用额度。 */
        @JsonProperty("used")
        private Integer used;

        /** 总配额。 */
        @JsonProperty("quotaTotal")
        private Integer quotaTotal;

        public String getQuotaId() {
            return this.quotaId;
        }

        public void setQuotaId(String quotaId) {
            this.quotaId = quotaId;
        }

        public Integer getUsed() {
            return this.used;
        }

        public void setUsed(Integer used) {
            this.used = used;
        }

        public Integer getQuotaTotal() {
            return this.quotaTotal;
        }

        public void setQuotaTotal(Integer quotaTotal) {
            this.quotaTotal = quotaTotal;
        }
    }

    public static
    class QueryQuotaTotalAndUsedReturnObjQuotaCenterDataListQuotaCenterUserResourceDataListResponse {
        /**
         * 配置项编码。
         * <li>dcs2_instanceCount_TQ_PID_202000: 租户缓存实例数量
         * <li>dcs2_busiQuota_TQ_totalMemSize: 租户缓存存储容量
         * <li>dcs2_instanceCount_UQ_PID_202000： 子账号缓存实例数量
         * <li>dcs2_busiQuota_UQ_totalMemSize: 子账号缓存存储容量
         */
        @JsonProperty("quotaId")
        private String quotaId;

        /** 已使用额度。 */
        @JsonProperty("used")
        private Integer used;

        /** 总配额。 */
        @JsonProperty("quotaTotal")
        private Integer quotaTotal;

        public String getQuotaId() {
            return this.quotaId;
        }

        public void setQuotaId(String quotaId) {
            this.quotaId = quotaId;
        }

        public Integer getUsed() {
            return this.used;
        }

        public void setUsed(Integer used) {
            this.used = used;
        }

        public Integer getQuotaTotal() {
            return this.quotaTotal;
        }

        public void setQuotaTotal(Integer quotaTotal) {
            this.quotaTotal = quotaTotal;
        }
    }
}
