package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Map;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询主节点可用区锁定设置 */
public class Dcs2QueryMaintainAzApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2QueryMaintainAzApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/instanceManageMgrServant/queryMaintainAz", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryMaintainAzResponse send(Credential credential, QueryMaintainAzRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryMaintainAzResponse.class);
    }

    public static class QueryMaintainAzRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }
    }

    public static class QueryMaintainAzResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private QueryMaintainAzReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public QueryMaintainAzReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryMaintainAzReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryMaintainAzReturnObjResponse {
        /** 可选的AZ列表,一般key是英文名,value是中文名 */
        @JsonProperty("az")
        private Map<String, String> az;

        /** 当前设置信息 */
        @JsonProperty("maintain")
        private QueryMaintainAzReturnObjMaintainResponse maintain;

        public Map<String, String> getAz() {
            return this.az;
        }

        public void setAz(Map<String, String> az) {
            this.az = az;
        }

        public QueryMaintainAzReturnObjMaintainResponse getMaintain() {
            return this.maintain;
        }

        public void setMaintain(QueryMaintainAzReturnObjMaintainResponse maintain) {
            this.maintain = maintain;
        }
    }

    public static class QueryMaintainAzReturnObjMaintainResponse {
        /** 是否开启 */
        @JsonProperty("enable")
        private Boolean enable;

        /** az名字，一般是中文名 */
        @JsonProperty("azName")
        private String azName;

        /** az名字，一般是英文名 */
        @JsonProperty("azEngName")
        private String azEngName;

        /**
         * 维护时间,有效值:
         * <li>allTime: 所有时间
         * <li>maintainTime: 维护时间
         */
        @JsonProperty("time")
        private String time;

        public Boolean getEnable() {
            return this.enable;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }

        public String getAzEngName() {
            return this.azEngName;
        }

        public void setAzEngName(String azEngName) {
            this.azEngName = azEngName;
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }
    }
}
