package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查看实例是否开通自动续费。 */
public class Dcs2QueryInstAutoRenewStatusApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2QueryInstAutoRenewStatusApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/res/spuInst/queryInstAutoRenewStatus", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryInstAutoRenewStatusResponse send(
            Credential credential, QueryInstAutoRenewStatusRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryInstAutoRenewStatusResponse.class);
    }

    public static class QueryInstAutoRenewStatusRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }
    }

    public static class QueryInstAutoRenewStatusResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private QueryInstAutoRenewStatusReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public QueryInstAutoRenewStatusReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryInstAutoRenewStatusReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryInstAutoRenewStatusReturnObjResponse {
        /** 错误信息。 */
        @JsonProperty("errorMsg")
        private String errorMsg;

        /** 数组 */
        @JsonProperty("resourcesDTOs")
        private List<QueryInstAutoRenewStatusReturnObjResourcesDTOsResponse> resourcesDTOs;

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public List<QueryInstAutoRenewStatusReturnObjResourcesDTOsResponse> getResourcesDTOs() {
            return this.resourcesDTOs;
        }

        public void setResourcesDTOs(
                List<QueryInstAutoRenewStatusReturnObjResourcesDTOsResponse> resourcesDTOs) {
            this.resourcesDTOs = resourcesDTOs;
        }
    }

    public static class QueryInstAutoRenewStatusReturnObjResourcesDTOsResponse {
        /** 虚拟实例标识。 */
        @JsonProperty("instanceId")
        private String instanceId;

        /** 主虚拟资源ID。 */
        @JsonProperty("masterResourceId")
        private String masterResourceId;

        /** 资源类型。 */
        @JsonProperty("resourceType")
        private String resourceType;

        /** 开始时间,值为 Unix 时间戳（毫秒级）。 */
        @JsonProperty("startDate")
        private String startDate;

        /** 到期时间,值为 Unix 时间戳（毫秒级）。 */
        @JsonProperty("expireDate")
        private String expireDate;

        /**
         * 自动续订状态。
         * <li>0/null：不自动续订。
         * <li>1：自动续订。
         */
        @JsonProperty("autoRenewStatus")
        private String autoRenewStatus;

        /**
         * 自动续订周期类型。
         * <li>3：月。
         * <li>5：年。
         */
        @JsonProperty("autoRenewCycleType")
        private String autoRenewCycleType;

        /** 自动续费时长。 */
        @JsonProperty("autoRenewCycleCount")
        private String autoRenewCycleCount;

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getMasterResourceId() {
            return this.masterResourceId;
        }

        public void setMasterResourceId(String masterResourceId) {
            this.masterResourceId = masterResourceId;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public String getStartDate() {
            return this.startDate;
        }

        public void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public String getExpireDate() {
            return this.expireDate;
        }

        public void setExpireDate(String expireDate) {
            this.expireDate = expireDate;
        }

        public String getAutoRenewStatus() {
            return this.autoRenewStatus;
        }

        public void setAutoRenewStatus(String autoRenewStatus) {
            this.autoRenewStatus = autoRenewStatus;
        }

        public String getAutoRenewCycleType() {
            return this.autoRenewCycleType;
        }

        public void setAutoRenewCycleType(String autoRenewCycleType) {
            this.autoRenewCycleType = autoRenewCycleType;
        }

        public String getAutoRenewCycleCount() {
            return this.autoRenewCycleCount;
        }

        public void setAutoRenewCycleCount(String autoRenewCycleCount) {
            this.autoRenewCycleCount = autoRenewCycleCount;
        }
    }
}
